/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.client.armor.render;

import net.kenddie.fantasyarmor.item.FAArmorItems;
import net.kenddie.fantasyarmor.item.armor.FAArmorSet;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="fantasy_armor", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FAClientEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        for (FAArmorSet set : FAArmorSet.values()) {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                Item item = (Item)FAArmorItems.getArmorItem(set, type).get();
                FAClientEventHandler.registerColorForItem(item, event.getItemColors());
            }
        }
    }

    private static void registerColorForItem(Item item, ItemColors itemColors) {
        itemColors.m_92689_((stack, tintIndex) -> {
            DyeableLeatherItem dyeable;
            if (tintIndex != 1) {
                return -1;
            }
            Item patt1661$temp = stack.m_41720_();
            if (!(patt1661$temp instanceof DyeableLeatherItem) || !(dyeable = (DyeableLeatherItem)patt1661$temp).m_41113_(stack)) {
                return -1;
            }
            return dyeable.m_41121_(stack);
        }, new ItemLike[]{item});
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        for (FAArmorSet set : FAArmorSet.values()) {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                Item item = (Item)FAArmorItems.getArmorItem(set, type).get();
                event.enqueueWork(() -> ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("fantasy_armor", "dyed"), (stack, level, entity, seed) -> {
                    DyeableLeatherItem dyeable;
                    Item patt2411$temp = stack.m_41720_();
                    if (patt2411$temp instanceof DyeableLeatherItem && (dyeable = (DyeableLeatherItem)patt2411$temp).m_41113_(stack)) {
                        return 1.0f;
                    }
                    return 0.0f;
                }));
            }
        }
    }
}

