/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.datagen.Datagen;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.SummonBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class AELootTables
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public AELootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn.getPackOutput(), new HashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.f_81421_)));
    }

    public static LootPool.Builder POD_BUILDER(Item item, Block block) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)ArchfruitPod.f_51736_, 2)))));
    }

    @NotNull
    public String getOldName() {
        return "Ars Elemental Loot Tables";
    }

    public static class BlockLootTable
    extends BlockLootSubProvider {
        public List<Block> list = new ArrayList<Block>();

        protected BlockLootTable() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_(), new HashMap());
        }

        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> p_249322_) {
            this.m_245660_();
            HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceLocation resourcelocation;
                if (!block.m_245993_(this.f_243739_) || (resourcelocation = block.m_60589_()) == BuiltInLootTables.f_78712_ || !set.add(resourcelocation) || (loottable$builder = (LootTable.Builder)this.f_244441_.remove(resourcelocation)) == null) continue;
                p_249322_.accept(resourcelocation, loottable$builder);
            }
        }

        protected void m_245660_() {
            HashSet blocks = new HashSet(ModItems.BLOCKS.getEntries());
            Datagen.takeAll(blocks, b -> b.get() instanceof LeavesBlock);
            Datagen.takeAll(blocks, b -> !(b.get() instanceof SummonBlock)).forEach(b -> this.registerDropSelf((Block)b.get()));
            this.registerLeavesAndSticks((Block)ModItems.FLASHING_LEAVES.get(), (Block)ModItems.FLASHING_SAPLING.get());
            this.list.add((Block)ModItems.MERMAID_ROCK.get());
            this.m_246125_((Block)ModItems.MERMAID_ROCK.get(), (ItemLike)Blocks.f_50377_);
            this.list.add((Block)ModItems.POT_FLASHING_SAPLING.get());
            this.m_246535_((Block)ModItems.POT_FLASHING_SAPLING.get());
            this.m_246481_((Block)ModItems.FLASHING_POD.get(), block -> LootTable.m_79147_().m_79161_(AELootTables.POD_BUILDER(block.m_5456_(), block)));
        }

        public void registerLeavesAndSticks(Block leaves, Block sapling) {
            this.list.add(leaves);
            this.m_246481_(leaves, l_state -> this.m_246047_((Block)l_state, sapling, DEFAULT_SAPLING_DROP_RATES));
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.m_245724_(block);
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return this.list;
        }
    }
}

