/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event.loot;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class IngredientModifier
extends LootModifier {
    public static final Codec<Ingredient> INGREDIENT = new PrimitiveCodec<Ingredient>(){

        public <T> DataResult<Ingredient> read(DynamicOps<T> ops, T input) {
            try {
                return DataResult.success((Object)Ingredient.m_43917_((JsonElement)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input))));
            }
            catch (JsonParseException e) {
                return DataResult.error(() -> "Failed to parse Ingredient: " + e.getMessage());
            }
        }

        public <T> T write(DynamicOps<T> ops, Ingredient value) {
            return (T)JsonOps.INSTANCE.convertTo(ops, value.m_43942_());
        }
    };
    public static final Supplier<Codec<IngredientModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> IngredientModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)INGREDIENT.fieldOf("addition").forGetter(m -> m.addition)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).and((App)Codec.BOOL.fieldOf("replace").orElse((Object)false).forGetter(m -> m.replace)).apply((Applicative)inst, IngredientModifier::new)));
    private final Ingredient addition;
    private final float chance;
    private final boolean replace;

    protected IngredientModifier(LootItemCondition[] conditionsIn, Ingredient addition, float chance, boolean replace) {
        super(conditionsIn);
        this.addition = addition;
        this.chance = chance;
        this.replace = replace;
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_230907_().m_188501_() <= this.chance) {
            if (this.replace && generatedLoot.size() > 0) {
                generatedLoot.remove(0);
            }
            Arrays.stream(this.addition.m_43908_()).forEach(itemStack -> generatedLoot.add((Object)itemStack.m_41777_()));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

