/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;

public class BeeCage
extends Item {
    public BeeCage(Item.Properties properties) {
        super(properties);
    }

    public static boolean isFilled(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return !itemStack.m_41619_() && itemStack.m_41720_() instanceof BeeCage && tag != null && tag.m_128441_("entity");
    }

    public static String getBeeType(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof BeeCage && tag != null && tag.m_128441_("entity")) {
            String type = tag.m_128461_("entity");
            if (type.equals("productivebees:configurable_bee")) {
                type = tag.m_128461_("type");
            }
            return type;
        }
        return null;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level playerWorld = context.m_43723_().m_20193_();
        ItemStack stack = context.m_43722_();
        if (playerWorld.m_5776_() || !BeeCage.isFilled(stack)) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Bee entity = BeeCage.getEntityFromStack(stack, level, true);
        if (entity != null) {
            if (entity.m_27896_(pos)) {
                entity.m_27876_(pos);
            } else if (context.m_43723_() != null && context.m_43723_().m_6144_() || entity.f_27698_ != null && !level.m_46749_(entity.f_27698_)) {
                entity.f_27698_ = null;
                if (entity instanceof ProductiveBee) {
                    ProductiveBee pBee = (ProductiveBee)entity;
                    if (level instanceof ServerLevel) {
                        pBee.setHasConverted(false);
                        pBee.m_27919_(false);
                        PoiManager poiManager = ((ServerLevel)level).m_8904_();
                        Optional poiAtLocation = poiManager.m_27177_(pos);
                        if (poiAtLocation.isPresent() && ((ProductiveBee)entity).getBeehiveInterests().test((Holder<PoiType>)((Holder)poiAtLocation.get()))) {
                            entity.f_27698_ = pos;
                        }
                    }
                }
            }
            BlockPos blockPos = pos.m_121945_(context.m_43719_());
            entity.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
            level.m_7967_((Entity)entity);
            this.postItemUse(context);
        }
        return InteractionResult.SUCCESS;
    }

    protected void postItemUse(UseOnContext context) {
        if (context.m_43723_() != null) {
            if (context.m_43723_().m_7500_()) {
                context.m_43723_().m_150109_().m_36057_(context.m_43722_());
            } else {
                context.m_43722_().m_41774_(1);
            }
        }
    }

    @Nonnull
    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity targetIn, InteractionHand hand) {
        Bee target;
        block9: {
            block8: {
                if (targetIn.m_20193_().m_5776_() || !(targetIn instanceof Bee)) break block8;
                target = (Bee)targetIn;
                if (targetIn.m_6084_() && !BeeCage.isFilled(itemStack)) break block9;
            }
            return InteractionResult.PASS;
        }
        boolean addToInventory = true;
        ItemStack cageStack = new ItemStack((ItemLike)itemStack.m_41720_());
        if (itemStack.m_41613_() == 1) {
            cageStack = itemStack;
            addToInventory = false;
        }
        if (target.m_21523_()) {
            target.m_21455_(true, true);
        }
        BeeCage.captureEntity(target, cageStack);
        if (addToInventory || player.m_7500_()) {
            if (!player.m_150109_().m_36054_(cageStack)) {
                player.m_36176_(cageStack, false);
            }
            itemStack.m_41774_(1);
        }
        player.m_6674_(hand);
        if (player instanceof ServerPlayer) {
            ModAdvancements.CATCH_BEE.trigger((ServerPlayer)player, cageStack);
        }
        target.m_146870_();
        return InteractionResult.SUCCESS;
    }

    public static void captureEntity(Bee target, ItemStack cageStack) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("entity", EntityType.m_20613_((EntityType)target.m_6095_()).toString());
        if (target.m_8077_()) {
            nbt.m_128359_("name", target.m_7770_().getString());
        } else {
            nbt.m_128359_("name", target.m_7755_().getString());
        }
        target.m_20240_(nbt);
        AdvancedBeehiveBlockEntityAbstract.removeIgnoredTags(nbt);
        if (target.m_27854_()) {
            nbt.m_128365_("HivePos", (Tag)NbtUtils.m_129224_((BlockPos)target.m_27855_()));
        }
        nbt.m_128379_("isProductiveBee", target instanceof ProductiveBee);
        String modId = BuiltInRegistries.f_256780_.m_7981_((Object)target.m_6095_()).m_135827_();
        String modName = ModList.get().getModObjectById(modId).get().getClass().getSimpleName();
        if (modId.equals("minecraft")) {
            modName = "Minecraft";
        }
        nbt.m_128359_("mod", modName);
        cageStack.m_41751_(nbt);
    }

    @Nullable
    public static Bee getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        return BeeCage.getEntityFromStack(stack.m_41783_(), world, withInfo);
    }

    @Nullable
    public static Bee getEntityFromStack(@Nullable CompoundTag tag, Level world, boolean withInfo) {
        EntityType type;
        if (tag != null && (type = (EntityType)EntityType.m_20632_((String)tag.m_128461_("entity")).orElse(null)) != null) {
            Entity entity = type.m_20615_(world);
            if (withInfo) {
                entity.m_20258_(tag);
            }
            if (entity instanceof Bee) {
                if (entity instanceof ConfigurableBee && !withInfo) {
                    ((ConfigurableBee)entity).setBeeType(tag.m_128461_("type"));
                }
                return (Bee)entity;
            }
        }
        return null;
    }

    @Nonnull
    public Component m_7626_(ItemStack stack) {
        if (!BeeCage.isFilled(stack)) {
            return Component.m_237115_((String)this.m_5524_());
        }
        String entityId = stack.m_41783_().m_128461_("name");
        return Component.m_237115_((String)this.m_5524_()).m_7220_((Component)Component.m_237113_((String)(" (" + entityId + ")")));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && !tag.equals((Object)new CompoundTag())) {
            if (Screen.m_96638_()) {
                boolean hasStung = tag.m_128471_("HasStung");
                if (hasStung) {
                    list.add((Component)Component.m_237115_((String)"productivebees.information.health.dying").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
                }
                BeeHelper.populateBeeInfoFromTag(tag, list);
                if (tag.m_128441_("HivePos")) {
                    list.add((Component)Component.m_237115_((String)"productivebees.information.cage_release"));
                }
            } else {
                list.add((Component)Component.m_237115_((String)"productivebees.information.hold_shift").m_130940_(ChatFormatting.WHITE));
            }
        }
    }
}

