/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.noise;

import net.minecraft.util.Mth;

public class CellularNoise {
    private static final long PRIME_X = 5910200641878280303L;
    private static final long PRIME_Y = 6452764530575939509L;
    private static final long PRIME_Z = 6614699811220273867L;
    private static final long HASH_MULTIPLIER = 6026932503003350773L;
    private static final int N_JITTER_HASH_BITS_PER_AXIS = 21;
    private static final int JITTER_HASH_MASK = 0x1FFFFF;
    private static final float JITTER_HASH_RESCALE = 4.7683716E-7f;
    private static final double ROOT3OVER3 = 0.577350269189626;
    private static final double ROTATE3_ORTHOGONALIZER = -0.21132486540518713;
    public static final float MAX_DISTANCE_SQUARED_TO_CLOSEST = 3.0f;
    public static final float MAX_DISTANCE_TO_CLOSEST = Mth.m_14116_((float)3.0f);

    public static float sampleDistance2Sub_ImproveXZ(long seed, double x, double y, double z) {
        double xz = x + z;
        double s2 = xz * -0.21132486540518713;
        double yy = y * 0.577350269189626;
        double xr = x + s2 + yy;
        double zr = z + s2 + yy;
        double yr = xz * -0.577350269189626 + yy;
        return CellularNoise.sampleDistance2Sub(seed, xr, yr, zr);
    }

    public static float sampleDistance2Sub(long seed, double x, double y, double z) {
        int xBaseStart = Mth.m_14107_((double)(x - (double)MAX_DISTANCE_TO_CLOSEST));
        int yBaseStart = Mth.m_14107_((double)(y - (double)MAX_DISTANCE_TO_CLOSEST));
        int zBaseStart = Mth.m_14107_((double)(z - (double)MAX_DISTANCE_TO_CLOSEST));
        int xRange = Mth.m_14107_((double)(x + (double)MAX_DISTANCE_TO_CLOSEST)) - xBaseStart;
        int yRange = Mth.m_14107_((double)(y + (double)MAX_DISTANCE_TO_CLOSEST)) - yBaseStart;
        int zRange = Mth.m_14107_((double)(z + (double)MAX_DISTANCE_TO_CLOSEST)) - zBaseStart;
        float xiStart = (float)(x - (double)xBaseStart);
        float yiStart = (float)(y - (double)yBaseStart);
        float ziStart = (float)(z - (double)zBaseStart);
        long xStartPrimed = (long)xBaseStart * 5910200641878280303L;
        long yStartPrimed = (long)yBaseStart * 6452764530575939509L;
        long zStartPrimed = (long)zBaseStart * 6614699811220273867L;
        float distSq1 = 3.0f;
        float distSq2 = 3.0f;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        float xi = xiStart;
        float yi = yiStart;
        float zi = ziStart;
        long xPrimed = xStartPrimed;
        long yPrimed = yStartPrimed;
        long zPrimed = zStartPrimed;
        while (true) {
            float distSqHere;
            if ((distSqHere = CellularNoise.calculateDistanceSquared(seed, xPrimed, yPrimed, zPrimed, xi, yi, zi)) < distSq2) {
                distSq2 = distSqHere;
                if (distSqHere < distSq1) {
                    distSq2 = distSq1;
                    distSq1 = distSqHere;
                }
            }
            xi -= 1.0f;
            xPrimed += 5910200641878280303L;
            if (++ix <= xRange) continue;
            ix = 0;
            xi = xiStart;
            xPrimed = xStartPrimed;
            yi -= 1.0f;
            yPrimed += 6452764530575939509L;
            if (++iy <= yRange) continue;
            iy = 0;
            yi = yiStart;
            yPrimed = yStartPrimed;
            zi -= 1.0f;
            zPrimed += 6614699811220273867L;
            if (++iz > zRange) break;
        }
        return Mth.m_14116_((float)distSq2) - Mth.m_14116_((float)distSq1);
    }

    private static float calculateDistanceSquared(long seed, long xPrimed, long yPrimed, long zPrimed, float xi, float yi, float zi) {
        long hash = CellularNoise.hash(seed, xPrimed, yPrimed, zPrimed);
        float jx = (float)((hash >> 43 ^ hash) & 0x1FFFFFL) * 4.7683716E-7f;
        float jy = (float)((hash >> 43 ^ hash >> 22) & 0x1FFFFFL) * 4.7683716E-7f;
        float jz = (float)(hash >> 43 & 0x1FFFFFL) * 4.7683716E-7f;
        return Mth.m_14207_((float)(xi - jx)) + Mth.m_14207_((float)(yi - jy)) + Mth.m_14207_((float)(zi - jz));
    }

    private static long hash(long seed, long xPrimed, long yPrimed, long zPrimed) {
        long hash = seed ^ xPrimed ^ yPrimed ^ zPrimed;
        return hash *= 6026932503003350773L;
    }
}

