/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import com.mojang.datafixers.util.Unit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;

public class ReloadInstanceWrapper
implements ReloadInstance {
    private final CompletableFuture<Unit> beforeTask;
    private final CompletableFuture<ReloadInstance> instanceFuture;
    private final IProgressTracker.Tree progressTracker = IProgressTracker.createTree(1);

    public static ReloadInstance wrap(Supplier<ReloadInstance> factory, PackType type, ResourceManager manager, Executor backgroundExecutor, Executor mainExecutor) {
        return new ReloadInstanceWrapper(factory, type, manager, backgroundExecutor, mainExecutor);
    }

    public static void executeEarlyReloadBlocking(PackType type, ResourceManager manager, IProgressTracker progressTracker) {
        MoonlightEventsHelper.postEvent(new EarlyPackReloadEvent(manager.m_7536_().toList(), manager, type, progressTracker), EarlyPackReloadEvent.class);
    }

    public ReloadInstanceWrapper(Supplier<ReloadInstance> factory, PackType type, ResourceManager manager, Executor backgroundExecutor, Executor mainExecutor) {
        this.beforeTask = CompletableFuture.supplyAsync(() -> {
            ReloadInstanceWrapper.executeEarlyReloadBlocking(type, manager, this.progressTracker);
            return Unit.INSTANCE;
        }, backgroundExecutor);
        this.instanceFuture = this.beforeTask.thenApplyAsync(u -> (ReloadInstance)factory.get(), mainExecutor);
    }

    public CompletableFuture<?> m_7237_() {
        return this.instanceFuture.thenCompose(ReloadInstance::m_7237_);
    }

    public float m_7750_() {
        if (!this.beforeTask.isDone()) {
            return this.progressTracker.getProgress();
        }
        ReloadInstance actual = this.instanceFuture.getNow(null);
        return actual != null ? actual.m_7750_() : 1.0f;
    }

    public void m_7748_() {
        ReloadInstance actual;
        if (!this.beforeTask.isDone()) {
            return;
        }
        if (this.beforeTask.isCompletedExceptionally()) {
            this.beforeTask.join();
        }
        if ((actual = (ReloadInstance)this.instanceFuture.getNow(null)) != null) {
            actual.m_7748_();
        }
    }
}

