/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiFunction;
import mod.azure.azurelibarmor.cache.object.GeoBone;
import mod.azure.azurelibarmor.core.animatable.GeoAnimatable;
import mod.azure.azurelibarmor.renderer.GeoRenderer;
import mod.azure.azurelibarmor.renderer.layer.GeoRenderLayer;
import mod.azure.azurelibarmor.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockAndItemGeoLayer<T extends GeoAnimatable>
extends GeoRenderLayer<T> {
    protected final BiFunction<GeoBone, T, ItemStack> stackForBone;
    protected final BiFunction<GeoBone, T, BlockState> blockForBone;

    public BlockAndItemGeoLayer(GeoRenderer<T> renderer) {
        this(renderer, (bone, animatable) -> null, (bone, animatable) -> null);
    }

    public BlockAndItemGeoLayer(GeoRenderer<T> renderer, BiFunction<GeoBone, T, ItemStack> stackForBone, BiFunction<GeoBone, T, BlockState> blockForBone) {
        super(renderer);
        this.stackForBone = stackForBone;
        this.blockForBone = blockForBone;
    }

    @Nullable
    protected ItemStack getStackForBone(GeoBone bone, T animatable) {
        return this.stackForBone.apply(bone, (GeoBone)animatable);
    }

    @Nullable
    protected BlockState getBlockForBone(GeoBone bone, T animatable) {
        return this.blockForBone.apply(bone, (GeoBone)animatable);
    }

    protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, T animatable) {
        return ItemDisplayContext.NONE;
    }

    @Override
    public void renderForBone(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        ItemStack stack = this.getStackForBone(bone, animatable);
        BlockState blockState = this.getBlockForBone(bone, animatable);
        if (stack == null && blockState == null) {
            return;
        }
        poseStack.m_85836_();
        RenderUtils.translateAndRotateMatrixForBone(poseStack, bone);
        if (stack != null) {
            this.renderStackForBone(poseStack, bone, stack, animatable, bufferSource, partialTick, packedLight, packedOverlay);
        }
        if (blockState != null) {
            this.renderBlockForBone(poseStack, bone, blockState, animatable, bufferSource, partialTick, packedLight, packedOverlay);
        }
        poseStack.m_85849_();
    }

    protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)animatable;
            Minecraft.m_91087_().m_91291_().m_269491_(livingEntity, stack, this.getTransformTypeForStack(bone, stack, animatable), false, poseStack, bufferSource, livingEntity.m_9236_(), packedLight, packedOverlay, livingEntity.m_19879_());
        } else {
            Minecraft.m_91087_().m_91291_().m_269128_(stack, this.getTransformTypeForStack(bone, stack, animatable), packedLight, packedOverlay, poseStack, bufferSource, (Level)Minecraft.m_91087_().f_91073_, (int)this.renderer.getInstanceId(animatable));
        }
    }

    protected void renderBlockForBone(PoseStack poseStack, GeoBone bone, BlockState state, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(-0.25f, -0.25f, -0.25f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        Minecraft.m_91087_().m_91289_().m_110912_(state, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }
}

