/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mod.azure.azurelibarmor.AzureLib;
import mod.azure.azurelibarmor.core.object.DataTicket;
import mod.azure.azurelibarmor.network.SerializableDataTicket;
import mod.azure.azurelibarmor.util.AzureLibUtil;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class DataTickets {
    private static final Map<String, SerializableDataTicket<?>> SERIALIZABLE_TICKETS = new ConcurrentHashMap();
    public static final DataTicket<ItemStack> ITEMSTACK = new DataTicket<ItemStack>("itemstack", ItemStack.class);
    public static final DataTicket<Entity> ENTITY = new DataTicket<Entity>("entity", Entity.class);
    public static final DataTicket<EquipmentSlot> EQUIPMENT_SLOT = new DataTicket<EquipmentSlot>("equipment_slot", EquipmentSlot.class);
    public static final DataTicket<Double> TICK = new DataTicket<Double>("tick", Double.class);
    public static final DataTicket<ItemDisplayContext> ITEM_RENDER_PERSPECTIVE = new DataTicket<ItemDisplayContext>("item_render_perspective", ItemDisplayContext.class);
    public static final SerializableDataTicket<Integer> ANIM_STATE = AzureLibUtil.addDataTicket(SerializableDataTicket.ofInt(new ResourceLocation("azurelibarmor", "anim_state")));
    public static final SerializableDataTicket<String> ANIM = AzureLibUtil.addDataTicket(SerializableDataTicket.ofString(new ResourceLocation("azurelibarmor", "anim")));
    public static final SerializableDataTicket<Integer> USE_TICKS = AzureLibUtil.addDataTicket(SerializableDataTicket.ofInt(new ResourceLocation("azurelibarmor", "use_ticks")));
    public static final SerializableDataTicket<Boolean> ACTIVE = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("azurelibarmor", "active")));
    public static final SerializableDataTicket<Boolean> OPEN = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("azurelibarmor", "open")));
    public static final SerializableDataTicket<Boolean> CLOSED = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("azurelibarmor", "closed")));
    public static final SerializableDataTicket<Direction> DIRECTION = AzureLibUtil.addDataTicket(SerializableDataTicket.ofEnum(new ResourceLocation("azurelibarmor", "direction"), Direction.class));

    @Nullable
    public static SerializableDataTicket<?> byName(String id) {
        return SERIALIZABLE_TICKETS.getOrDefault(id, null);
    }

    public static <D> SerializableDataTicket<D> registerSerializable(SerializableDataTicket<D> ticket) {
        SerializableDataTicket<D> existingTicket = SERIALIZABLE_TICKETS.putIfAbsent(ticket.id(), ticket);
        if (existingTicket != null) {
            AzureLib.LOGGER.error("Duplicate SerializableDataTicket registered! This will cause issues. Existing: {}, New: {}", (Object)existingTicket.id(), (Object)ticket.id());
        }
        return ticket;
    }

    private DataTickets() {
        throw new UnsupportedOperationException();
    }
}

