/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.util.PlayerEquipsUtil;
import java.util.function.Predicate;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ComputeFovModifierEvent;

public final class BowUtils {
    public static void setupBowFov(ComputeFovModifierEvent event, Predicate<Item> predicate, float zoomValue) {
        float oldFOV = event.getFovModifier();
        float newFOV = 1.0f;
        ItemStack stack = event.getPlayer().m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        int ticks = event.getPlayer().m_21252_();
        if (item instanceof BowItem && PlayerEquipsUtil.hasArrowInInventory(event.getPlayer())) {
            float zoom = 1.0f;
            if (!predicate.test(item)) {
                return;
            }
            zoom = zoomValue;
            newFOV = oldFOV - (float)ticks * zoom / 20.0f;
            if (newFOV < oldFOV - zoom) {
                newFOV = oldFOV - zoom;
            }
            event.setNewFovModifier(newFOV);
        }
    }

    public static void setupBowModelProperties(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (itemStack, world, livingEntity, seed) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, world, livingEntity, seed) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }
}

