/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import org.dawnoftime.armoroftheages.CommonClass;
import org.dawnoftime.armoroftheages.client.ArmorModelSupplier;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;
import org.dawnoftime.armoroftheages.config.AOTAConfig;
import org.dawnoftime.armoroftheages.config.PreferredModel;
import org.jetbrains.annotations.NotNull;

public class ArmorModelProvider {
    protected static final ResourceLocation PLAYER_RESOURCE_LOCATION = new ResourceLocation("minecraft:player");
    private final Supplier<LayerDefinition> layerDefinitionSupplier;
    protected final ArmorModelSupplier modelSupplier;
    private ArmorModel<?> armorModel;
    private final ModelLayerLocation modelLayerLocation;
    private final ResourceLocation resourceLocation;

    public static ArmorModelProvider create(String armorName, EquipmentSlot slot, ArmorModelSupplier modelSupplier, Supplier<LayerDefinition> layerDefinitionSupplier) {
        return new ArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier);
    }

    public static ArmorModelProvider create(String armorName, EquipmentSlot slot, ArmorModelSupplier modelSupplier, Supplier<LayerDefinition> layerDefinitionSupplier, Supplier<LayerDefinition> slimLayerDefinitionSupplier) {
        return new MixedArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier, slimLayerDefinitionSupplier);
    }

    protected ArmorModelProvider(String armorName, EquipmentSlot slot, ArmorModelSupplier modelSupplier, Supplier<LayerDefinition> layerDefinitionSupplier) {
        this.layerDefinitionSupplier = layerDefinitionSupplier;
        this.modelSupplier = modelSupplier;
        this.modelLayerLocation = new ModelLayerLocation(PLAYER_RESOURCE_LOCATION, armorName + "_" + slot.name().toLowerCase());
        this.resourceLocation = new ResourceLocation("armoroftheages", "textures/models/armor/" + armorName + ".png");
    }

    @NotNull
    public ResourceLocation getTexture(Entity entity) {
        return this.resourceLocation;
    }

    @NotNull
    public ModelLayerLocation getLayerLocation() {
        return this.modelLayerLocation;
    }

    public LayerDefinition createLayer() {
        return this.layerDefinitionSupplier.get();
    }

    public static boolean isSlim(Entity entity) {
        AbstractClientPlayer player;
        if (entity == Minecraft.m_91087_().f_91074_ && AOTAConfig.get().usePreferredModel) {
            return AOTAConfig.get().preferredModel == PreferredModel.FEMALE;
        }
        if (!AOTAConfig.get().ignoredSynchronizedPreferredModel && CommonClass.CURRENT_PREFERRED_MODEL_MAP.containsKey(entity.m_20148_())) {
            return CommonClass.CURRENT_PREFERRED_MODEL_MAP.get(entity.m_20148_()) == PreferredModel.FEMALE;
        }
        return entity instanceof AbstractClientPlayer && "slim".equals((player = (AbstractClientPlayer)entity).m_108564_());
    }

    public ArmorModel<?> getArmorModel(Entity entity) {
        if (this.armorModel == null) {
            this.armorModel = this.modelSupplier.create(Minecraft.m_91087_().m_167973_().m_171103_(this.modelLayerLocation), false);
        }
        return this.armorModel;
    }

    public static class MixedArmorModelProvider
    extends ArmorModelProvider {
        private final Supplier<LayerDefinition> slimLayerDefinitionSupplier;
        private final ModelLayerLocation slimModelLayerLocation;
        private final ResourceLocation slimResourceLocation;
        private ArmorModel<?> slimArmorModel;

        protected MixedArmorModelProvider(String armorName, EquipmentSlot slot, ArmorModelSupplier modelSupplier, Supplier<LayerDefinition> layerDefinitionSupplier, Supplier<LayerDefinition> slimLayerDefinitionSupplier) {
            super(armorName, slot, modelSupplier, layerDefinitionSupplier);
            this.slimLayerDefinitionSupplier = slimLayerDefinitionSupplier;
            this.slimModelLayerLocation = new ModelLayerLocation(PLAYER_RESOURCE_LOCATION, armorName + "_" + slot.name().toLowerCase() + "_slim");
            this.slimResourceLocation = new ResourceLocation("armoroftheages", "textures/models/armor/" + armorName + "_slim.png");
        }

        @NotNull
        public ModelLayerLocation getSlimLayerLocation() {
            return this.slimModelLayerLocation;
        }

        public LayerDefinition createSlimLayer() {
            return this.slimLayerDefinitionSupplier.get();
        }

        @Override
        @NotNull
        public ResourceLocation getTexture(Entity entity) {
            return MixedArmorModelProvider.isSlim(entity) ? this.slimResourceLocation : super.getTexture(entity);
        }

        @Override
        public ArmorModel<?> getArmorModel(Entity entity) {
            if (ArmorModelProvider.isSlim(entity)) {
                if (this.slimArmorModel == null) {
                    this.slimArmorModel = this.modelSupplier.create(Minecraft.m_91087_().m_167973_().m_171103_(this.slimModelLayerLocation), true);
                }
                return this.slimArmorModel;
            }
            return super.getArmorModel(entity);
        }
    }
}

