/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin.mixins.client;

import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.mixin.AetherMixinHooks;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.SlotResult;

@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerMixin {
    @Inject(at={@At(value="HEAD")}, method={"isCapeLoaded()Z"}, cancellable=true)
    private void isCapeLoaded(CallbackInfoReturnable<Boolean> cir) {
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        if (EquipmentUtil.hasCape((LivingEntity)player) && AetherMixinHooks.isCapeVisible((LivingEntity)player)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getCloakTextureLocation()Lnet/minecraft/resources/ResourceLocation;"}, cancellable=true)
    private void getCloakTextureLocation(CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation texture;
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        SlotResult result = EquipmentUtil.getCape((LivingEntity)player);
        if (result != null && AetherMixinHooks.isCapeVisible((LivingEntity)player) && (texture = AetherMixinHooks.getCapeTexture(result.stack())) != null) {
            cir.setReturnValue((Object)texture);
        }
    }
}

