/*
 * Decompiled with CFR 0.152.
 */
package net.cebularz.droppedbuffs.entity.entities;

import java.util.Random;
import net.cebularz.droppedbuffs.DroppedBuffsConfig;
import net.cebularz.droppedbuffs.api.Buff;
import net.cebularz.droppedbuffs.api.BuffRegistry;
import net.cebularz.droppedbuffs.entity.ModEntities;
import net.cebularz.droppedbuffs.entity.entities.Buff_Entity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class Basic_Buff_Entity
extends Entity {
    private ResourceLocation buffId;
    public Player owner = null;
    public float bobOffset;
    public int age = 0;
    public float rotationY;
    public float rotationX;
    public float rotationZ;
    public float alpha;
    public float duration;
    protected int color;

    public Basic_Buff_Entity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        Random random = new Random();
        this.rotationX = 180.0f;
        this.rotationY = 0.0f;
        this.rotationZ = 0.0f;
        this.alpha = 1.0f;
        this.duration = DroppedBuffsConfig.buff_on_ground_duration * 20;
        this.color = 0xFFFFFF;
    }

    public void setBuffId(ResourceLocation buffId) {
        this.buffId = buffId;
    }

    public Buff getBuff() {
        return BuffRegistry.getBuff(this.buffId);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        this.bobOffset = (float)(Math.sin((double)this.f_19797_ * 0.1) * 0.1);
        if ((float)this.age >= this.duration - 80.0f) {
            this.alpha -= 0.0125f;
        }
        super.m_8119_();
        ++this.age;
        if ((float)this.age >= this.duration) {
            this.m_146870_();
        }
        this.rotationY = (this.rotationY + 2.0f) % 360.0f;
        float oscillationFactor = 0.5f;
        float speedFactor = 0.1f;
        this.rotationX = 180.0f + 30.0f * (float)Math.sin((float)this.f_19797_ * speedFactor * 0.7f) * oscillationFactor;
        this.rotationZ = 30.0f * (float)Math.cos((float)this.f_19797_ * speedFactor) * oscillationFactor;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("BuffID")) {
            this.buffId = new ResourceLocation(compoundTag.m_128461_("BuffID"));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (this.buffId != null) {
            compoundTag.m_128359_("BuffID", this.buffId.toString());
        }
    }

    public void m_6123_(Player player) {
        super.m_6123_(player);
        if ((player == this.owner || this.owner == null || DroppedBuffsConfig.global_drop) && !this.m_9236_().f_46443_) {
            Buff buff = this.getBuff();
            if (buff != null) {
                buff.onPickup(player);
                Buff_Entity buffEntity = new Buff_Entity((EntityType)ModEntities.BUFF_ENTITY.get(), this.m_9236_());
                buffEntity.setColorMultiplier(buff.getColor());
                buffEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                buffEntity.setOwner(player);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_276532_, SoundSource.BLOCKS, 2.0f, 1.0f);
                this.m_9236_().m_7967_((Entity)buffEntity);
            }
            this.m_146870_();
        }
    }

    public void buffOnPickUpEffect(Player player) {
    }

    public static void spawnBuff(Player player, LivingDeathEvent event) {
    }
}

