/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.covers1624.quack.util.SneakyUtils;

public class LambdaUtils {
    public static <T> boolean forEach(Iterable<T> iterable, Predicate<T> predicate) {
        for (T e : iterable) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> void forEach(E[] elements, Consumer<E> consumer) {
        for (E element : elements) {
            consumer.accept(element);
        }
    }

    public static <E> void checkArgument(E argument, String log, Predicate<E> predicate) {
        if (predicate.test(argument)) {
            throw new RuntimeException("Argument check failed! Reason: " + log);
        }
    }

    public static void tryQuietly(SneakyUtils.ThrowingRunnable<Throwable> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> T tryOrNull(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

