/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class CompositeItemModel
implements IGeometryLoader<Geometry> {
    public Geometry read(JsonObject jsonObject, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject childrenObj = jsonObject.getAsJsonObject("children");
        if (childrenObj == null) {
            throw new JsonParseException("Composite model requires children.");
        }
        ImmutableMap<String, BlockModel> children = FastStream.of(childrenObj.entrySet()).toImmutableMap(Map.Entry::getKey, e -> (BlockModel)ctx.deserialize((JsonElement)e.getValue(), BlockModel.class));
        JsonArray itemPassesArr = jsonObject.getAsJsonArray("item_render_order");
        ImmutableList<String> itemPasses = itemPassesArr != null ? FastStream.of(itemPassesArr).map(JsonElement::getAsString).peek(e -> {
            if (!children.containsKey(e)) {
                throw new JsonParseException("Invalid child in item_render_order." + e + " does not exist.");
            }
        }).toImmutableList() : ImmutableList.copyOf(children.keySet());
        return new Geometry((Map<String, BlockModel>)children, (List<String>)itemPasses);
    }

    public record Geometry(Map<String, BlockModel> children, List<String> itemPasses) implements IUnbakedGeometry<Geometry>
    {
        public BakedModel bake(final IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            final TextureAtlasSprite particle = spriteGetter.apply(context.getMaterial("particle"));
            ModelState effectiveState = Geometry.composeState(context.getRootTransform(), modelState);
            final ImmutableMap<String, BakedModel> children = FastStream.of(this.children.entrySet()).filter(e -> context.isComponentVisible((String)e.getKey(), true)).toImmutableMap(Map.Entry::getKey, e -> ((BlockModel)e.getValue()).m_111449_(baker, (BlockModel)e.getValue(), spriteGetter, effectiveState, modelLocation, true));
            final ImmutableList<BakedModel> itemPasses = FastStream.of(this.itemPasses).map(arg_0 -> children.get(arg_0)).toImmutableList();
            class Overrides
            extends ItemOverrides {
                Overrides() {
                }

                @Nullable
                public BakedModel m_173464_(BakedModel pModel, ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
                    ImmutableList<BakedModel> iPasses = FastStream.of(itemPasses).map(e -> e.m_7343_().m_173464_(e, pStack, pLevel, pEntity, pSeed)).toImmutableList();
                    return new CompositeModel.Baked(context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion(), particle, context.getTransforms(), (ItemOverrides)this, children, iPasses);
                }
            }
            return new CompositeModel.Baked(context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion(), particle, context.getTransforms(), (ItemOverrides)new Overrides(), children, itemPasses);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.children.values().forEach(value -> value.m_5500_(modelGetter));
        }

        public Set<String> getConfigurableComponentNames() {
            return this.children.keySet();
        }

        private static ModelState composeState(Transformation rootTransform, ModelState state) {
            if (rootTransform.isIdentity()) {
                return state;
            }
            return UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)state, (Transformation)rootTransform);
        }
    }
}

