/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.covers1624.quack.image.AnimatedGifEncoder;
import net.covers1624.quack.platform.OperatingSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class ItemFileRenderer {
    public static final int DEFAULT_RES = 512;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LinkedList<RenderTask> tasks = new LinkedList();
    private static final Path OUTPUT = Paths.get("exports", new String[0]);
    @Nullable
    private static RenderTarget target;

    public static void renderStatic(ItemStack stack, String file, int resolution) {
        tasks.add(new StaticRenderTask(stack, resolution, OUTPUT.resolve(file)));
    }

    public static void addGifRenderTask(ItemStack stack, String file, int resolution, int fps, int duration) {
        tasks.add(new GifRenderTask(stack, resolution, OUTPUT.resolve(file), fps, duration));
    }

    public static boolean addWebpRenderTask(ItemStack stack, String file, int resolution, int fps, int duration) {
        if (!WebpRenderTask.isFfmpegAvailable()) {
            return false;
        }
        tasks.add(new WebpRenderTask(stack, resolution, OUTPUT.resolve(file), fps, duration));
        return true;
    }

    public static void tick() {
        RenderTask task = tasks.peek();
        if (task != null && ItemFileRenderer.guardRender(task)) {
            tasks.pop();
        }
    }

    private static boolean guardRender(RenderTask task) {
        try {
            return task.render();
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to render.", ex);
            return true;
        }
    }

    private static class StaticRenderTask
    extends RenderTask {
        private StaticRenderTask(ItemStack stack, int resolution, Path path) {
            super(stack, resolution, path);
        }

        @Override
        protected boolean render() throws IOException {
            try (NativeImage image = this.takeItemScreenshot();){
                image.m_85122_();
                image.m_85066_(this.path);
            }
            return true;
        }
    }

    private static class GifRenderTask
    extends AnimatedRenderTask {
        private GifRenderTask(ItemStack stack, int resolution, Path path, int fps, int duration) {
            super(stack, resolution, path, fps, duration);
        }

        @Override
        protected void serialize() throws IOException {
            try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);){
                AnimatedGifEncoder encoder = new AnimatedGifEncoder();
                encoder.start(os);
                encoder.setDelay((int)this.frameDelay);
                encoder.setRepeat(0);
                encoder.setQuality(1);
                for (int i = 0; i < this.frames.size(); ++i) {
                    NativeImage frame;
                    LOGGER.info("Encoding Frame {} / {}", (Object)(i + 1), (Object)this.frames.size());
                    try (NativeImage nativeImage = frame = (NativeImage)this.frames.get(i);){
                        encoder.addFrame(ImageIO.read(new ByteArrayInputStream(frame.m_85121_())));
                        continue;
                    }
                }
                encoder.finish();
                LOGGER.info("Finished writing gif.");
            }
        }
    }

    private static class WebpRenderTask
    extends AnimatedRenderTask {
        public static final Supplier<@Nullable String> FFMPEG_BINARY = Suppliers.memoize(() -> {
            String ffmpeg = System.getProperty("ccl.ffmpeg", "ffmpeg" + (OperatingSystem.current().isWindows() ? ".exe" : ""));
            LOGGER.info("Probing for ffmpeg with {}", (Object)ffmpeg);
            try {
                int ret = WebpRenderTask.runFfmpeg(List.of(ffmpeg, "-version"), arg_0 -> ((Logger)LOGGER).info(arg_0));
                if (ret == 0) {
                    LOGGER.info("ffmpeg available via {}", (Object)ffmpeg);
                    return ffmpeg;
                }
                LOGGER.error("Failed to find working ffmpeg. Got exit code: {}", (Object)ret);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to find ffmpeg. Exception whilst running command.", (Throwable)ex);
            }
            return null;
        });

        public static boolean isFfmpegAvailable() {
            return FFMPEG_BINARY.get() != null;
        }

        private WebpRenderTask(ItemStack stack, int resolution, Path path, int fps, int duration) {
            super(stack, resolution, path, fps, duration);
        }

        @Override
        protected void serialize() throws IOException {
            Path tempDir = this.path.getParent().resolve(this.path.getFileName() + ".tmp");
            Files.createDirectory(tempDir, new FileAttribute[0]);
            LOGGER.info("Dumping frames to temp directory..");
            int i = 0;
            ArrayList<Path> tempFiles = new ArrayList<Path>(this.frames.size() + 1);
            Iterator iterator = this.frames.iterator();
            while (iterator.hasNext()) {
                NativeImage frame;
                NativeImage nativeImage = frame = (NativeImage)iterator.next();
                try {
                    Path file = tempDir.resolve(i++ + ".png");
                    tempFiles.add(file);
                    frame.m_85066_(file);
                }
                finally {
                    if (nativeImage == null) continue;
                    nativeImage.close();
                }
            }
            tempFiles.add(tempDir);
            int ret = WebpRenderTask.runFfmpeg(List.of(FFMPEG_BINARY.get(), "-y", "-framerate", String.valueOf(this.fps), "-i", tempDir.toAbsolutePath() + "/%d.png", "-loop", "0", "-lossless", "1", "-compression_level", "0", this.path.toAbsolutePath().toString()), arg_0 -> ((Logger)LOGGER).info(arg_0));
            if (ret != 0) {
                LOGGER.error("ffmpeg exited with exit code {}", (Object)ret);
            } else {
                LOGGER.info("ffmpeg success!");
            }
            for (Path tempFile : tempFiles) {
                Files.deleteIfExists(tempFile);
            }
        }

        private static int runFfmpeg(List<String> args, Consumer<String> out) throws IOException {
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));){
                reader.lines().forEach(out);
            }
            proc.onExit().join();
            return proc.exitValue();
        }
    }

    private static abstract class RenderTask {
        private static final boolean DEBUG = Boolean.getBoolean("ccl.ItemFileRenderer.debug");
        protected final ItemStack stack;
        protected final int resolution;
        protected final Path path;

        private RenderTask(ItemStack stack, int resolution, Path path) {
            this.stack = stack;
            this.resolution = resolution;
            this.path = path;
        }

        protected abstract boolean render() throws IOException;

        protected NativeImage takeItemScreenshot() {
            long start = System.nanoTime();
            Minecraft mc = Minecraft.m_91087_();
            PoseStack pStack = RenderSystem.getModelViewStack();
            GuiGraphics guiGraphics = new GuiGraphics(mc, mc.m_91269_().m_110104_());
            if (target == null || ItemFileRenderer.target.f_83915_ < this.resolution || ItemFileRenderer.target.f_83916_ < this.resolution) {
                if (target == null) {
                    target = new RenderTarget(true){};
                }
                target.m_83941_(this.resolution, this.resolution, Minecraft.f_91002_);
            }
            Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)this.resolution * 16.0f / (float)this.resolution, (float)this.resolution * 16.0f / (float)this.resolution, 0.0f, -3000.0f, 3000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)ortho, (VertexSorting)VertexSorting.f_276633_);
            pStack.m_85836_();
            pStack.m_166856_();
            RenderSystem.applyModelViewMatrix();
            target.m_83947_(true);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClearDepth((double)1.0);
            GL11.glClear((int)16640);
            Lighting.m_84931_();
            RenderSystem.enableCull();
            long preRender = System.nanoTime();
            if (DEBUG) {
                LOGGER.info("Setup: {}ns", (Object)(preRender - start));
            }
            guiGraphics.m_280480_(this.stack, 0, 0);
            long postRender = System.nanoTime();
            if (DEBUG) {
                LOGGER.info("Render: {}ns", (Object)(postRender - preRender));
            }
            NativeImage image = new NativeImage(this.resolution, this.resolution, false);
            target.m_83956_();
            image.m_85045_(0, false);
            image.m_85122_();
            if (DEBUG) {
                LOGGER.info("Screenshot: {}ns", (Object)(System.nanoTime() - postRender));
            }
            pStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            target.m_83970_();
            return image;
        }
    }

    private static abstract class AnimatedRenderTask
    extends RenderTask {
        protected final int fps;
        protected final long targetDuration;
        protected final List<NativeImage> frames;
        protected final long frameDelay;
        protected long startTime = -1L;
        protected long lastFrame;
        @Nullable
        private CompletableFuture<Void> finalizeTask;

        private AnimatedRenderTask(ItemStack stack, int resolution, Path path, int fps, int duration) {
            super(stack, resolution, path);
            this.fps = fps;
            this.targetDuration = TimeUnit.SECONDS.toMillis(duration);
            this.frames = new ArrayList<NativeImage>(duration * fps);
            this.frameDelay = (long)(1.0f / (float)fps * 1000.0f);
        }

        @Override
        protected boolean render() {
            long currTime = System.currentTimeMillis();
            if (this.startTime == -1L) {
                this.startTime = currTime;
            }
            if (this.startTime + this.targetDuration <= currTime) {
                if (this.finalizeTask == null) {
                    this.finalizeTask = CompletableFuture.runAsync(() -> {
                        try {
                            this.serialize();
                        }
                        catch (Throwable ex) {
                            LOGGER.error("Failed to serialize item render task.", ex);
                        }
                    });
                }
                return this.finalizeTask.isDone();
            }
            if (this.lastFrame + this.frameDelay > currTime) {
                return false;
            }
            this.lastFrame = currTime;
            this.frames.add(this.takeItemScreenshot());
            LOGGER.info("Captured frame {} / {}", (Object)this.frames.size(), (Object)(this.targetDuration / 1000L * (long)this.fps));
            return false;
        }

        protected abstract void serialize() throws IOException;
    }
}

