/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.events.ClientEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkEvent;

public class PacketAuraChunk {
    private int chunkX;
    private int chunkZ;
    private Collection<AuraChunk.DrainSpot> drainSpots;

    public PacketAuraChunk(int chunkX, int chunkZ, Collection<AuraChunk.DrainSpot> drainSpots) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.drainSpots = drainSpots;
    }

    private PacketAuraChunk() {
    }

    public static PacketAuraChunk fromBytes(FriendlyByteBuf buf) {
        PacketAuraChunk packet = new PacketAuraChunk();
        packet.chunkX = buf.readInt();
        packet.chunkZ = buf.readInt();
        packet.drainSpots = new ArrayList<AuraChunk.DrainSpot>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            packet.drainSpots.add(new AuraChunk.DrainSpot(buf.m_130260_()));
        }
        return packet;
    }

    public static void toBytes(PacketAuraChunk packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.chunkX);
        buf.writeInt(packet.chunkZ);
        buf.writeInt(packet.drainSpots.size());
        for (AuraChunk.DrainSpot entry : packet.drainSpots) {
            buf.m_130079_(entry.serializeNBT());
        }
    }

    public static void onMessage(PacketAuraChunk message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEvents.PENDING_AURA_CHUNKS.add(message));
        ctx.get().setPacketHandled(true);
    }

    public boolean tryHandle(Level level) {
        try {
            LevelChunk chunk = level.m_6325_(this.chunkX, this.chunkZ);
            if (chunk.m_6430_()) {
                return false;
            }
            AuraChunk auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.CAP_AURA_CHUNK).orElse(null);
            if (auraChunk == null) {
                return false;
            }
            auraChunk.setSpots(this.drainSpots);
            return true;
        }
        catch (Exception e) {
            NaturesAura.LOGGER.error("There was an error handling an aura chunk packet", (Throwable)e);
            return true;
        }
    }
}

