/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.items.ItemImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemRangeVisualizer
extends ItemImpl {
    public static final ListMultimap<ResourceLocation, BlockPos> VISUALIZED_BLOCKS = ArrayListMultimap.create();
    public static final ListMultimap<ResourceLocation, Entity> VISUALIZED_ENTITIES = ArrayListMultimap.create();
    public static final ListMultimap<ResourceLocation, BlockPos> VISUALIZED_RAILS = ArrayListMultimap.create();

    public ItemRangeVisualizer() {
        super("range_visualizer", new Item.Properties().m_41487_(1));
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public static void clear() {
        if (!VISUALIZED_BLOCKS.isEmpty()) {
            VISUALIZED_BLOCKS.clear();
        }
        if (!VISUALIZED_ENTITIES.isEmpty()) {
            VISUALIZED_ENTITIES.clear();
        }
        if (!VISUALIZED_RAILS.isEmpty()) {
            VISUALIZED_RAILS.clear();
        }
    }

    public static <T> void visualize(Player player, ListMultimap<ResourceLocation, T> map, ResourceLocation dim, T value) {
        if (map.containsEntry((Object)dim, value)) {
            map.remove((Object)dim, value);
            player.m_5661_((Component)Component.m_237115_((String)"info.naturesaura.range_visualizer.end"), true);
        } else {
            map.put((Object)dim, value);
            player.m_5661_((Component)Component.m_237115_((String)"info.naturesaura.range_visualizer.start"), true);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            ItemRangeVisualizer.clear();
            playerIn.m_5661_((Component)Component.m_237115_((String)"info.naturesaura.range_visualizer.end_all"), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        Block block = state.m_60734_();
        if (block instanceof IVisualizable) {
            if (level.f_46443_) {
                ItemRangeVisualizer.visualize(context.m_43723_(), VISUALIZED_BLOCKS, level.m_46472_().m_135782_(), pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public class EventHandler {
        @SubscribeEvent
        public void onInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            ItemStack stack = event.getItemStack();
            if (stack.m_41619_() || stack.m_41720_() != ItemRangeVisualizer.this) {
                return;
            }
            Entity entity = event.getTarget();
            if (entity instanceof IVisualizable) {
                if (entity.m_9236_().f_46443_) {
                    ResourceLocation dim = entity.m_9236_().m_46472_().m_135782_();
                    ItemRangeVisualizer.visualize(event.getEntity(), VISUALIZED_ENTITIES, dim, entity);
                }
                event.getEntity().m_6674_(event.getHand());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

