/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

public class BlockEntityFlowerGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private final Map<BlockState, MutableInt> consumedRecently = new HashMap<BlockState, MutableInt>();

    public BlockEntityFlowerGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FLOWER_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 10L == 0L) {
            ArrayList<BlockPos> possible = new ArrayList<BlockPos>();
            int range = 3;
            for (int x = -range; x <= range; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos offset = this.f_58858_.m_7918_(x, y, z);
                        BlockState state = this.f_58857_.m_8055_(offset);
                        if (!state.m_204336_(BlockTags.f_13037_)) continue;
                        possible.add(offset);
                    }
                }
            }
            if (possible.isEmpty()) {
                return;
            }
            int addAmount = 25000;
            BlockPos pos = (BlockPos)possible.get(this.f_58857_.f_46441_.m_188503_(possible.size()));
            BlockState state = this.f_58857_.m_8055_(pos);
            MutableInt curr = this.consumedRecently.computeIfAbsent(state, s -> new MutableInt());
            int toAdd = Math.max(0, addAmount - curr.getValue() * 100);
            if (toAdd > 0) {
                if (IAuraType.forLevel(this.f_58857_).isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) && this.canGenerateRightNow(toAdd)) {
                    this.generateAura(toAdd);
                } else {
                    toAdd = 0;
                }
            }
            for (Map.Entry<BlockState, MutableInt> entry : this.consumedRecently.entrySet()) {
                MutableInt val;
                if (entry.getKey() == state || (val = entry.getValue()).getValue() <= 0) continue;
                val.subtract(1);
            }
            curr.add(5);
            this.f_58857_.m_7471_(pos, false);
            int color = Helper.blendColors(6081584, 15023126, (float)toAdd / (float)addAmount);
            if (toAdd > 0) {
                for (int i = this.f_58857_.f_46441_.m_188503_(5) + 5; i >= 0; --i) {
                    PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticleStream((float)pos.m_123341_() + 0.25f + this.f_58857_.f_46441_.m_188501_() * 0.5f, (float)pos.m_123342_() + 0.25f + this.f_58857_.f_46441_.m_188501_() * 0.5f, (float)pos.m_123343_() + 0.25f + this.f_58857_.f_46441_.m_188501_() * 0.5f, (float)this.f_58858_.m_123341_() + 0.25f + this.f_58857_.f_46441_.m_188501_() * 0.5f, (float)this.f_58858_.m_123342_() + 0.25f + this.f_58857_.f_46441_.m_188501_() * 0.5f, (float)this.f_58858_.m_123343_() + 0.25f + this.f_58857_.f_46441_.m_188501_() * 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.02f + 0.1f, color, 1.0f));
                }
                PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.FLOWER_GEN_AURA_CREATION, new int[0]));
            }
            PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), PacketParticles.Type.FLOWER_GEN_CONSUME, color));
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.SYNC && !this.consumedRecently.isEmpty()) {
            ListTag list = new ListTag();
            for (Map.Entry<BlockState, MutableInt> entry : this.consumedRecently.entrySet()) {
                BlockState state = entry.getKey();
                Block block = state.m_60734_();
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
                tag.m_128405_("amount", entry.getValue().intValue());
                list.add((Object)tag);
            }
            compound.m_128365_("consumed_recently", (Tag)list);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.SYNC) {
            this.consumedRecently.clear();
            ListTag list = compound.m_128437_("consumed_recently", 10);
            for (Tag base : list) {
                CompoundTag tag = (CompoundTag)base;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_("block")));
                if (block == null) continue;
                this.consumedRecently.put(block.m_49966_(), new MutableInt(tag.m_128451_("amount")));
            }
        }
    }
}

