/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockImpl;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ItemModelBuilder;

public class BlockGoldPowder
extends BlockImpl
implements IColorProvidingBlock,
ICustomBlockState,
ICustomItemModel {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.f_61383_;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.f_61382_;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.f_61384_;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.f_61385_;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)};

    public BlockGoldPowder() {
        super("gold_powder", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50088_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(NORTH, (Comparable)RedstoneSide.NONE)).m_61124_(EAST, (Comparable)RedstoneSide.NONE)).m_61124_(SOUTH, (Comparable)RedstoneSide.NONE)).m_61124_(WEST, (Comparable)RedstoneSide.NONE));
    }

    private static int getShapeIndex(BlockState state) {
        boolean w;
        int i = 0;
        boolean n = state.m_61143_(NORTH) != RedstoneSide.NONE;
        boolean e = state.m_61143_(EAST) != RedstoneSide.NONE;
        boolean s = state.m_61143_(SOUTH) != RedstoneSide.NONE;
        boolean bl = w = state.m_61143_(WEST) != RedstoneSide.NONE;
        if (n || s && !n && !e && !w) {
            i |= 1 << Direction.NORTH.m_122416_();
        }
        if (e || w && !n && !e && !s) {
            i |= 1 << Direction.EAST.m_122416_();
        }
        if (s || n && !e && !s && !w) {
            i |= 1 << Direction.SOUTH.m_122416_();
        }
        if (w || e && !n && !s && !w) {
            i |= 1 << Direction.WEST.m_122416_();
        }
        return i;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public BlockColor getBlockColor() {
        return (state, levelIn, pos, tintIndex) -> 16042818;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPES[BlockGoldPowder.getShapeIndex(state)];
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(WEST, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.WEST))).m_61124_(EAST, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.EAST))).m_61124_(NORTH, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.NORTH))).m_61124_(SOUTH, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.SOUTH));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        return facing == Direction.UP ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_(WEST, (Comparable)this.getSide((BlockGetter)levelIn, currentPos, Direction.WEST))).m_61124_(EAST, (Comparable)this.getSide((BlockGetter)levelIn, currentPos, Direction.EAST))).m_61124_(NORTH, (Comparable)this.getSide((BlockGetter)levelIn, currentPos, Direction.NORTH))).m_61124_(SOUTH, (Comparable)this.getSide((BlockGetter)levelIn, currentPos, Direction.SOUTH)) : (BlockState)stateIn.m_61124_((Property)RedStoneWireBlock.f_55501_.get(facing), (Comparable)this.getSide((BlockGetter)levelIn, currentPos, facing));
    }

    private RedstoneSide getSide(BlockGetter levelIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.m_121945_(face);
        BlockState blockstate = levelIn.m_8055_(blockpos);
        BlockPos blockpos1 = pos.m_7494_();
        BlockState blockstate1 = levelIn.m_8055_(blockpos1);
        if (!blockstate1.m_60838_(levelIn, blockpos1)) {
            boolean flag;
            boolean bl = flag = blockstate.m_60783_(levelIn, blockpos, Direction.UP) || blockstate.m_60734_() == Blocks.f_50332_;
            if (flag && this.canConnectTo(levelIn.m_8055_(blockpos.m_7494_()))) {
                if (blockstate.m_60838_(levelIn, blockpos)) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !this.canConnectTo(blockstate) && (blockstate.m_60838_(levelIn, blockpos) || !this.canConnectTo(levelIn.m_8055_(blockpos.m_7495_()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    protected boolean canConnectTo(BlockState blockState) {
        Block block = blockState.m_60734_();
        return block == this;
    }

    public boolean m_7898_(BlockState state, LevelReader levelIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = levelIn.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)levelIn, blockpos, Direction.UP) || blockstate.m_60734_() == Blocks.f_50332_;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_6807_(BlockState state, Level levelIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_() && !levelIn.f_46443_) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                levelIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(levelIn, pos.m_121945_(direction1));
            }
            for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.m_121945_(direction2);
                if (levelIn.m_8055_(blockpos).m_60838_((BlockGetter)levelIn, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(levelIn, blockpos.m_7494_());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(levelIn, blockpos.m_7495_());
            }
        }
    }

    public void m_6810_(BlockState state, Level levelIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, levelIn, pos, newState, isMoving);
            if (!levelIn.f_46443_) {
                for (Direction direction : Direction.values()) {
                    levelIn.m_46672_(pos.m_121945_(direction), (Block)this);
                }
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.notifyWireNeighborsOfStateChange(levelIn, pos.m_121945_(direction1));
                }
                for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                    BlockPos blockpos = pos.m_121945_(direction2);
                    if (levelIn.m_8055_(blockpos).m_60838_((BlockGetter)levelIn, blockpos)) {
                        this.notifyWireNeighborsOfStateChange(levelIn, blockpos.m_7494_());
                        continue;
                    }
                    this.notifyWireNeighborsOfStateChange(levelIn, blockpos.m_7495_());
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level levelIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!levelIn.f_46443_ && !state.m_60710_((LevelReader)levelIn, pos)) {
            Block.m_49950_((BlockState)state, (Level)levelIn, (BlockPos)pos);
            levelIn.m_7471_(pos, false);
        }
    }

    public void m_7742_(BlockState state, LevelAccessor levelIn, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos pool = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.m_61143_((Property)RedStoneWireBlock.f_55501_.get(direction));
            if (redstoneside == RedstoneSide.NONE || levelIn.m_8055_((BlockPos)pool.m_122190_((Vec3i)pos).m_122173_(direction)).m_60734_() == this) continue;
            pool.m_122173_(Direction.DOWN);
            BlockState blockstate = levelIn.m_8055_((BlockPos)pool);
            if (blockstate.m_60734_() != Blocks.f_50455_) {
                BlockPos blockpos = pool.m_121945_(direction.m_122424_());
                BlockState blockstate1 = blockstate.m_60728_(direction.m_122424_(), levelIn.m_8055_(blockpos), levelIn, (BlockPos)pool, blockpos);
                Block.m_49902_((BlockState)blockstate, (BlockState)blockstate1, (LevelAccessor)levelIn, (BlockPos)pool, (int)flags);
            }
            pool.m_122190_((Vec3i)pos).m_122173_(direction).m_122173_(Direction.UP);
            BlockState blockstate3 = levelIn.m_8055_((BlockPos)pool);
            if (blockstate3.m_60734_() == Blocks.f_50455_) continue;
            BlockPos blockpos1 = pool.m_121945_(direction.m_122424_());
            BlockState blockstate2 = blockstate3.m_60728_(direction.m_122424_(), levelIn.m_8055_(blockpos1), levelIn, (BlockPos)pool, blockpos1);
            Block.m_49902_((BlockState)blockstate3, (BlockState)blockstate2, (LevelAccessor)levelIn, (BlockPos)pool, (int)flags);
        }
    }

    private void notifyWireNeighborsOfStateChange(Level levelIn, BlockPos pos) {
        if (levelIn.m_8055_(pos).m_60734_() == this) {
            levelIn.m_46672_(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                levelIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "item/" + this.getBaseName());
    }
}

