/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityFurnaceHeater;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockFurnaceHeater
extends BlockContainerImpl
implements ICustomBlockState {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)16.0), Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0)};

    public BlockFurnaceHeater() {
        super("furnace_heater", BlockEntityFurnaceHeater.class, BlockBehaviour.Properties.m_284310_().m_60978_(3.0f));
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level levelIn, BlockPos pos, RandomSource rand) {
        BlockEntity tile = levelIn.m_7702_(pos);
        if (tile instanceof BlockEntityFurnaceHeater) {
            BlockEntityFurnaceHeater heater = (BlockEntityFurnaceHeater)tile;
            if (heater.isActive) {
                float z;
                float y;
                float x;
                Direction facing = (Direction)stateIn.m_61143_((Property)FACING);
                if (facing == Direction.UP) {
                    x = 0.35f + rand.m_188501_() * 0.3f;
                    y = 0.0f;
                    z = 0.35f + rand.m_188501_() * 0.3f;
                } else if (facing == Direction.DOWN) {
                    x = 0.35f + rand.m_188501_() * 0.3f;
                    y = 1.0f;
                    z = 0.35f + rand.m_188501_() * 0.3f;
                } else {
                    x = facing.m_122431_() != 0 ? 0.35f + rand.m_188501_() * 0.3f : (facing.m_122429_() < 0 ? 1.0f : 0.0f);
                    y = 0.35f + rand.m_188501_() * 0.3f;
                    z = facing.m_122429_() != 0 ? 0.35f + rand.m_188501_() * 0.3f : (facing.m_122431_() < 0 ? 1.0f : 0.0f);
                }
                NaturesAuraAPI.instance().spawnMagicParticle((float)pos.m_123341_() + x, (float)pos.m_123342_() + y, (float)pos.m_123343_() + z, (rand.m_188501_() * 0.016f + 0.01f) * (float)facing.m_122429_(), (rand.m_188501_() * 0.016f + 0.01f) * (float)facing.m_122430_(), (rand.m_188501_() * 0.016f + 0.01f) * (float)facing.m_122431_(), 16019010, rand.m_188501_() + 0.5f, 55, 0.0f, true, true);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)FACING)).m_122411_()];
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.directionalBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

