/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder().m_41487_(1).m_41486_(), () -> SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        boolean enchanted = this.isEnchanted(stack);
        this.addItemUse(tooltip, enchanted ? "2" : "1", new Object[0]);
        if (enchanted) {
            tooltip.add((Component)ModPerks.witch_doctor.getCurrentBonusInfo(EntityHelper.getPerkLevelWithBonus(ModTombstone.PROXY.getClientPlayer(), ModPerks.witch_doctor)).m_6881_().m_130948_(StyleType.INFO));
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.m_246342_(new ItemStack((ItemLike)this));
            toAdd.m_246342_(this.createEnchantedStack());
        }
    }

    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.m_6879_()).m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    public boolean preventDeath(ServerPlayer player) {
        ItemStack voodooPoppet = InventoryHelper.findFirstInInventory((Player)player, p -> p.m_150930_((Item)this) && p.getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).map(cap -> cap.isEnchanted((ItemStack)p)).orElse(false) != false);
        if (voodooPoppet.m_41619_()) {
            return false;
        }
        int chance = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.witch_doctor) * 10;
        if (Helper.RANDOM.nextInt(100) >= chance) {
            voodooPoppet.m_41774_(1);
        }
        LangKey.sendSystemMessage((Player)player, (Component)LangKey.MESSAGE_VOODOO_POPPET_PREVENT_DEATH.getText(StyleType.MESSAGE_SPECIAL, new Object[0]));
        ModTriggers.PREVENT_DEATH_VOODOO_POPPET.trigger(player);
        player.m_21153_(player.m_21233_());
        EffectHelper.clearBadEffects((LivingEntity)player);
        return true;
    }

    public ItemStack createEnchantedStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        return NBTStackHelper.setBoolean(stack, "enchant", true);
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        return NBTStackHelper.setBoolean(stack, "enchant", true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new SoulConsumerProvider(this);
    }
}

