/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.capability;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface ISoulConsumer {
    public static final Component MESSAGE_ENCHANT_ITEM_SUCCESS = Component.m_237115_((String)"tombstone.message.enchant_item.success");
    public static final Component MESSAGE_ENCHANT_ITEM_FAILED = Component.m_237115_((String)"tombstone.message.enchant_item.failed");

    public boolean isEnchanted(ItemStack var1);

    public ConsumeResult setEnchant(Level var1, BlockPos var2, ServerPlayer var3, ItemStack var4, int var5);

    default public boolean isUsingOffhandToEnchant() {
        return false;
    }

    default public boolean onSneakGrave(ServerLevel serverLevel, BlockPos gravePos, ServerPlayer serverPlayer, ItemStack stack) {
        return false;
    }

    default public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return true;
    }

    default public int getKnowledge() {
        return 1;
    }

    default public int getCorruptionLevel(ItemStack stack) {
        return this.isEnchanted(stack) ? 0 : 5;
    }

    public record ConsumeResult(Result result, Component message, int soulStrength) {
        public static ConsumeResult success(int soulStrength) {
            return new ConsumeResult(Result.SUCCESS, MESSAGE_ENCHANT_ITEM_SUCCESS, soulStrength);
        }

        public static ConsumeResult success(Component message, int soulStrength) {
            return new ConsumeResult(Result.SUCCESS, message, soulStrength);
        }

        public static ConsumeResult fail() {
            return new ConsumeResult(Result.FAIL, MESSAGE_ENCHANT_ITEM_FAILED, 0);
        }

        public static ConsumeResult fail(Component message) {
            return new ConsumeResult(Result.FAIL, message, 0);
        }

        public static enum Result {
            SUCCESS,
            FAIL;


            public boolean success() {
                return this == SUCCESS;
            }

            public boolean fail() {
                return this == FAIL;
            }
        }
    }
}

