/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.access.DamageSourceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.source.builtin.DealDamageExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.HealExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.SharedKillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerChunk;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerEntity;
import net.puffish.skillsmod.util.AttackerInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private int entityDroppedXp = 0;
    @Unique
    private final Map<ServerPlayer, Float> damageShare = new WeakHashMap<ServerPlayer, Float>();
    @Unique
    private final AntiFarmingPerEntity.State antiFarmingPerEntityState = new AntiFarmingPerEntity.State();

    @Inject(method={"heal"}, at={@At(value="TAIL")})
    private void injectAtHeal(float amount, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (amount > 0.0f && (livingEntity = (LivingEntity)this) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            SkillsAPI.updateExperienceSources(player, HealExperienceSource.class, es -> (int)Math.round(es.calculation().evaluate(new HealExperienceSource.Data(player, amount))));
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="TAIL")})
    private void injectAtApplyDamage(DamageSource source, float damage, CallbackInfo ci) {
        AttackerInfo.detect(source.m_7639_(), attackerInfo -> {
            LivingEntity entity = (LivingEntity)this;
            ItemStack weapon = ((DamageSourceAccess)source).getWeapon().orElse(ItemStack.f_41583_);
            ServerPlayer player = attackerInfo.player();
            AntiFarmingPerChunk.State antiFarmingPerChunkState = ((WorldChunkAccess)entity.m_9236_().m_46745_(entity.m_20183_())).getAntiFarmingPerChunkState();
            antiFarmingPerChunkState.removeOutdated();
            this.damageShare.compute(player, (key, value) -> {
                if (value == null) {
                    return Float.valueOf(damage);
                }
                return Float.valueOf(value.floatValue() + damage);
            });
            this.antiFarmingPerEntityState.removeOutdated();
            SkillsAPI.updateExperienceSources(player, DealDamageExperienceSource.class, es -> {
                if (attackerInfo.matchesTamedActivity(es.tamedActivity())) {
                    float limitedDamage;
                    if (es.antiFarmingPerChunk().map(antiFarmingPerChunkState::tryIncrement).orElse(true).booleanValue() && (limitedDamage = es.antiFarmingPerEntity().map(antiFarming -> Float.valueOf(this.antiFarmingPerEntityState.addAndLimit((AntiFarmingPerEntity)antiFarming, damage))).orElse(Float.valueOf(damage)).floatValue()) > 1.0E-5f) {
                        return (int)Math.round(es.calculation().evaluate(new DealDamageExperienceSource.Data(player, entity, weapon, limitedDamage, source)));
                    }
                }
                return 0;
            });
        });
    }

    @Inject(method={"drop"}, at={@At(value="TAIL")})
    private void injectAtDrop(DamageSource source, CallbackInfo ci) {
        AttackerInfo.detect(source.m_7639_(), attackerInfo -> {
            LivingEntity entity = (LivingEntity)this;
            ItemStack weapon = ((DamageSourceAccess)source).getWeapon().orElse(ItemStack.f_41583_);
            ServerPlayer player = attackerInfo.player();
            AntiFarmingPerChunk.State antiFarmingPerChunkState = ((WorldChunkAccess)entity.m_9236_().m_46745_(entity.m_20183_())).getAntiFarmingPerChunkState();
            antiFarmingPerChunkState.removeOutdated();
            SkillsAPI.updateExperienceSources(player, KillEntityExperienceSource.class, es -> {
                if (attackerInfo.matchesTamedActivity(es.tamedActivity())) {
                    if (es.antiFarmingPerChunk().map(antiFarmingPerChunkState::tryIncrement).orElse(true).booleanValue()) {
                        return (int)Math.round(es.calculation().evaluate(new KillEntityExperienceSource.Data(player, entity, weapon, source, this.entityDroppedXp)));
                    }
                }
                return 0;
            });
            Set<Map.Entry<ServerPlayer, Float>> entries = this.damageShare.entrySet();
            double totalDamage = entries.stream().mapToDouble(Map.Entry::getValue).sum();
            for (Map.Entry<ServerPlayer, Float> entry : entries) {
                SkillsAPI.updateExperienceSources(entry.getKey(), SharedKillEntityExperienceSource.class, es -> {
                    if (attackerInfo.matchesTamedActivity(es.tamedActivity())) {
                        if (es.antiFarmingPerChunk().map(antiFarmingPerChunkState::tryIncrement).orElse(true).booleanValue()) {
                            return (int)Math.round(es.calculation().evaluate(new SharedKillEntityExperienceSource.Data((ServerPlayer)entry.getKey(), entity, weapon, source, this.entityDroppedXp, totalDamage, entries.size(), (double)((Float)entry.getValue()).floatValue() / totalDamage)));
                        }
                    }
                    return 0;
                });
            }
        });
    }

    @ModifyArg(method={"dropXp"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    private int injectAtDropXp(int droppedXp) {
        this.entityDroppedXp = droppedXp;
        return droppedXp;
    }
}

