/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.events.OnPlayerInteracted;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.platform.Side;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@AutoInstance
public class HarvesterEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.UNCOMMON).category(MajruszsEnchantments.IS_HOE).slots((List)EquipmentSlots.HANDS).maxLevel(3).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 15);
    }

    public HarvesterEnchantment() {
        super(MajruszsEnchantments.HARVESTER, HarvesterEnchantment.class, false);
        OnPlayerInteracted.listen(this::apply).addCondition(data -> data.blockResult != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)data.itemStack)).addCondition(data -> BlockHelper.isCropAtMaxAge((Level)data.getLevel(), (BlockPos)data.blockResult.m_82425_()));
    }

    private void apply(OnPlayerInteracted data) {
        this.collectNearbyCrops(data);
        if (Side.isLogicalServer()) {
            Result result = this.harvestNearbyCrops(data);
            this.spawnItems(data, result);
            this.damageHoe(data, result);
        }
        data.finish();
    }

    private void collectNearbyCrops(OnPlayerInteracted data) {
        int range = EnchantmentHelper.getLevel((Supplier)this.enchantment, (ItemStack)data.itemStack) - 1;
        for (int z = -range; z <= range; ++z) {
            for (int x = -range; x <= range; ++x) {
                BlockPos blockPos = AnyPos.from((BlockPos)data.blockResult.m_82425_()).add((Number)x, (Number)0, (Number)z).block();
                BlockState blockState = data.getLevel().m_8055_(blockPos);
                if (!BlockHelper.isCropAtMaxAge((BlockState)blockState)) continue;
                blockState.m_60734_().m_5707_(data.getLevel(), blockPos, blockState, data.player);
            }
        }
    }

    private void spawnItems(OnPlayerInteracted data, Result result) {
        result.itemStacks.forEach(itemStack -> Block.m_49840_((Level)data.getLevel(), (BlockPos)data.blockResult.m_82425_(), (ItemStack)itemStack));
    }

    private Result harvestNearbyCrops(OnPlayerInteracted data) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        int count = 0;
        int range = EnchantmentHelper.getLevel((Supplier)this.enchantment, (ItemStack)data.itemStack) - 1;
        for (int z = -range; z <= range; ++z) {
            for (int x = -range; x <= range; ++x) {
                Optional<List<ItemStack>> drops = this.tryToHarvest(data, x, z);
                if (!drops.isPresent()) continue;
                ++count;
                itemStacks.addAll((Collection<ItemStack>)drops.get());
            }
        }
        return new Result(itemStacks, count);
    }

    private Optional<List<ItemStack>> tryToHarvest(OnPlayerInteracted data, int x, int z) {
        BlockPos blockPos;
        Level level = data.getLevel();
        BlockState blockState = level.m_8055_(blockPos = AnyPos.from((BlockPos)data.blockResult.m_82425_()).add((Number)x, (Number)0, (Number)z).block());
        if (!BlockHelper.isCropAtMaxAge((BlockState)blockState)) {
            return Optional.empty();
        }
        Block block = blockState.m_60734_();
        Item seed = block.m_7397_((BlockGetter)level, blockPos, blockState).m_41720_();
        List drops = blockState.m_287290_(new LootParams.Builder(data.getServerLevel()).m_287286_(LootContextParams.f_81460_, (Object)AnyPos.from((BlockPos)blockPos).center().vec3()).m_287286_(LootContextParams.f_81463_, (Object)data.itemStack).m_287286_(LootContextParams.f_81461_, (Object)blockState).m_287286_(LootContextParams.f_81455_, (Object)data.player));
        for (ItemStack itemStack : drops) {
            if (!itemStack.m_150930_(seed)) continue;
            itemStack.m_41764_(itemStack.m_41613_() - 1);
            level.m_46597_(blockPos, block.m_49966_());
            return Optional.of(drops);
        }
        for (Slot slot : data.player.f_36095_.f_38839_) {
            ItemStack itemStack = slot.m_7993_();
            if (!itemStack.m_150930_(seed)) continue;
            itemStack.m_41764_(itemStack.m_41613_() - 1);
            level.m_46597_(blockPos, block.m_49966_());
            return Optional.of(drops);
        }
        level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
        return Optional.of(drops);
    }

    private void damageHoe(OnPlayerInteracted data, Result result) {
        ItemHelper.damage((LivingEntity)data.player, (InteractionHand)data.hand, (int)result.cropsCount);
    }

    private record Result(List<ItemStack> itemStacks, int cropsCount) {
    }
}

