/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.curses;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class SlipperyCurse
extends Handler {
    float chance = 0.03f;
    float cooldown = 1.0f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(MajruszsEnchantments.IS_TOOL).slots((List)EquipmentSlots.HANDS).curse().minLevelCost(level -> 10).maxLevelCost(level -> 50);
    }

    public SlipperyCurse() {
        super(MajruszsEnchantments.SLIPPERY, SlipperyCurse.class, true);
        OnEntityTicked.listen(this::dropItem).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown(() -> Float.valueOf(this.cooldown))).addCondition(Condition.chance(() -> Float.valueOf(this.chance))).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.entity));
        this.config.define("drop_chance", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
            this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("drop_cooldown", Reader.number(), s -> Float.valueOf(this.cooldown), (s, v) -> {
            this.cooldown = ((Float)Range.of((Number)Float.valueOf(0.05f), (Number)Float.valueOf(60.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void dropItem(OnEntityTicked data) {
        EquipmentSlot slot = EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)data.entity.m_21205_()) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        ItemStack itemStack = data.entity.m_6844_(slot);
        LivingEntity livingEntity = data.entity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36176_(itemStack, false);
        } else {
            ItemEntity entity = new ItemEntity(data.getLevel(), data.entity.m_20185_(), data.entity.m_20185_(), data.entity.m_20185_(), itemStack);
            entity.m_32010_(40);
        }
        data.entity.m_8061_(slot, ItemStack.f_41583_);
    }
}

