/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.inventory.container.modular.ModularGuiContainerMenu;
import codechicken.lib.inventory.container.modular.ModularSlot;
import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.google.common.collect.Streams;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class ModularItemMenu
extends ModularGuiContainerMenu
implements ModuleHostContainer {
    private PlayerSlot slot;
    public ItemStack hostStack;
    private ModuleGrid moduleGrid;
    private ModuleHost moduleHost;
    private Player player;
    public final SlotGroup main = this.createSlotGroup(0, new int[0]);
    public final SlotGroup hotBar = this.createSlotGroup(0, new int[0]);
    public final SlotGroup armor = this.createSlotGroup(0, new int[0]);
    public final SlotGroup offhand = this.createSlotGroup(0, new int[0]);
    public final SlotGroup curios = this.createSlotGroup(0, new int[0]);

    public ModularItemMenu(int windowId, Inventory inv, FriendlyByteBuf extraData) {
        this(windowId, inv, PlayerSlot.fromBuff((ByteBuf)extraData));
    }

    public ModularItemMenu(int windowId, Inventory inv, PlayerSlot itemSlot) {
        super((MenuType)DEContent.MENU_MODULAR_ITEM.get(), windowId, inv);
        this.player = inv.f_35978_;
        this.slot = itemSlot;
        this.onContainerOpen();
        this.moduleGrid = new ModuleGrid(this, inv);
        this.hotBar.addPlayerBar(inv);
        this.main.addPlayerMain(inv);
        this.armor.addPlayerArmor(inv);
        this.offhand.addPlayerOffhand(inv);
        EquipmentManager.getEquipmentInventory((LivingEntity)inv.f_35978_).ifPresent(handler -> this.curios.addSlots(handler.getSlots(), 0, i -> new ModularSlot((IItemHandler)handler, i.intValue())));
    }

    private static Stream<ItemStack> getPlayerInventory(Inventory player) {
        return Streams.concat((Stream[])new Stream[]{player.f_35974_.stream(), player.f_35975_.stream(), player.f_35976_.stream()}).filter(e -> !e.m_41619_());
    }

    public static void tryOpenGui(ServerPlayer sender) {
        ItemStack stack = sender.m_21205_();
        if (!stack.m_41619_() && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            PlayerSlot slot = new PlayerSlot((Player)sender, InteractionHand.MAIN_HAND);
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new Provider(stack, slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        PlayerSlot slot = PlayerSlot.findStackActiveFirst((Inventory)sender.m_150109_(), e -> e.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent());
        if (slot != null) {
            NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)new Provider(slot.getStackInSlot((Player)sender), slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        sender.m_213846_((Component)Component.m_237115_((String)"modular_item.draconicevolution.error.no_modular_items").m_130940_(ChatFormatting.RED));
    }

    @Override
    public ModuleHost getModuleHost() {
        LazyOptional optional;
        if ((this.moduleHost == null || EffectiveSide.get().isClient()) && (optional = this.hostStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY)).isPresent()) {
            this.moduleHost = (ModuleHost)optional.orElseThrow(RuntimeException::new);
        }
        return this.moduleHost;
    }

    @Override
    public ModuleContext getModuleContext() {
        return new StackModuleContext(this.hostStack, (LivingEntity)this.player, this.slot.getEquipmentSlot());
    }

    @Override
    public void onGridChange() {
        if (EffectiveSide.get().isServer()) {
            for (int i = 0; i < this.f_38839_.size(); ++i) {
                ItemStack itemstack = ((Slot)this.f_38839_.get(i)).m_7993_();
                ItemStack itemstack1 = (ItemStack)this.f_38841_.get(i);
                if (ItemStack.m_41728_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                itemstack1 = itemstack.m_41777_();
                this.f_38841_.set(i, (Object)itemstack1);
                for (ContainerListener icontainerlistener : this.f_38848_) {
                    icontainerlistener.m_7934_((AbstractContainerMenu)this, i, itemstack1);
                }
            }
        }
    }

    private void onContainerOpen() {
        this.hostStack = this.slot.getStackInSlot(this.player);
        this.getModuleHost();
    }

    public boolean m_6875_(Player playerIn) {
        if (this.hostStack.m_41619_() || this.moduleHost == null || this.hostStack != this.slot.getStackInSlot(this.player)) {
            return false;
        }
        return this.moduleHost == this.hostStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse(null);
    }

    public ItemStack m_7648_(Player player, int i) {
        if (this.quickMoveModule(player, this.m_38853_(i))) {
            return ItemStack.f_41583_;
        }
        return super.m_7648_(player, i);
    }

    @Override
    public ModuleGrid getGrid() {
        return this.moduleGrid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        ItemStack stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.m_41619_() && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            this.hostStack = stack;
        }
    }

    public void m_182410_(int stateId, List<ItemStack> stacks, ItemStack carried) {
        super.m_182410_(stateId, stacks, carried);
        ItemStack stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.m_41619_() && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            this.hostStack = stack;
        }
    }

    public void m_182406_(int slotID, int stateId, ItemStack stack) {
        super.m_182406_(slotID, stateId, stack);
        stack = this.slot.getStackInSlot(this.player);
        if (stack != this.hostStack && !stack.m_41619_() && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            this.hostStack = stack;
        }
    }

    public void m_150399_(int slotId, int button, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.f_38839_.size() && (slot = (Slot)this.f_38839_.get(slotId)) != null && !slot.m_7993_().m_41619_()) {
            if (slot.m_7993_() == this.hostStack) {
                return;
            }
            if (clickTypeIn == ClickType.PICKUP && button == 0 && player.f_36096_.m_142621_().m_41619_() && slot.m_7993_().getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
                if (player instanceof ServerPlayer) {
                    PlayerSlot playerSlot = slotId >= 41 ? new PlayerSlot(slotId - 41, PlayerSlot.EnumInvCategory.EQUIPMENT) : (slotId >= 40 ? new PlayerSlot(slotId - 40, PlayerSlot.EnumInvCategory.OFF_HAND) : (slotId >= 36 ? new PlayerSlot(3 - (slotId - 36), PlayerSlot.EnumInvCategory.ARMOR) : new PlayerSlot(slotId, PlayerSlot.EnumInvCategory.MAIN)));
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new Provider(slot.m_7993_(), playerSlot), arg_0 -> ((PlayerSlot)playerSlot).toBuff(arg_0));
                } else {
                    player.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.25f, 1.0f);
                }
                return;
            }
        }
        if (slotId > 40) {
            return;
        }
        super.m_150399_(slotId, button, clickTypeIn, player);
    }

    public static class Provider
    implements MenuProvider {
        private ItemStack stack;
        private PlayerSlot slot;

        public Provider(ItemStack stack, PlayerSlot slot) {
            this.stack = stack;
            this.slot = slot;
        }

        public Component m_5446_() {
            return this.stack.m_41786_().m_6879_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.draconicevolution.modular_item.modules"));
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int menuID, Inventory playerInventory, Player playerEntity) {
            return new ModularItemMenu(menuID, playerInventory, this.slot);
        }
    }
}

