/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import codechicken.lib.model.ModelRegistryHelper;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.client.hud.HudManager;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import com.brandon3055.draconicevolution.client.CustomBossInfoHandler;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.ModuleTextures;
import com.brandon3055.draconicevolution.client.gui.CelestialManipulatorGui;
import com.brandon3055.draconicevolution.client.gui.DisenchanterGui;
import com.brandon3055.draconicevolution.client.gui.DraconiumChestGui;
import com.brandon3055.draconicevolution.client.gui.EnergyCoreGui;
import com.brandon3055.draconicevolution.client.gui.EnergyTransfuserGui;
import com.brandon3055.draconicevolution.client.gui.EntityDetectorGui;
import com.brandon3055.draconicevolution.client.gui.FlowGateGui;
import com.brandon3055.draconicevolution.client.gui.FusionCraftingCoreGui;
import com.brandon3055.draconicevolution.client.gui.GeneratorGui;
import com.brandon3055.draconicevolution.client.gui.GrinderGui;
import com.brandon3055.draconicevolution.client.gui.ReactorGui;
import com.brandon3055.draconicevolution.client.gui.modular.ModularItemGui;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ConfigurableItemGui;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.handler.ModularItemRenderOverrideHandler;
import com.brandon3055.draconicevolution.client.handler.OverlayRenderHandler;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.client.keybinding.KeyInputHandler;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianCrystalRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianProjectileRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianWitherRenderer;
import com.brandon3055.draconicevolution.client.render.entity.projectile.DraconicArrowRenderer;
import com.brandon3055.draconicevolution.client.render.hud.ShieldHudElement;
import com.brandon3055.draconicevolution.client.render.item.RenderItemChaosShard;
import com.brandon3055.draconicevolution.client.render.item.RenderItemDraconiumChest;
import com.brandon3055.draconicevolution.client.render.item.RenderItemEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.item.RenderItemMobSoul;
import com.brandon3055.draconicevolution.client.render.item.RenderItemReactorComponent;
import com.brandon3055.draconicevolution.client.render.item.RenderModularAxe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularBow;
import com.brandon3055.draconicevolution.client.render.item.RenderModularChestpiece;
import com.brandon3055.draconicevolution.client.render.item.RenderModularHoe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularPickaxe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularShovel;
import com.brandon3055.draconicevolution.client.render.item.RenderModularStaff;
import com.brandon3055.draconicevolution.client.render.item.RenderModularSword;
import com.brandon3055.draconicevolution.client.render.tile.DraconiumChestTileRenderer;
import com.brandon3055.draconicevolution.client.render.tile.RenderEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCelestialManipulator;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileChaosCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCraftingInjector;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDisenchanter;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDislocatorPedestal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyPylon;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyTransfuser;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEntityDetector;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileFusionCraftingCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileGenerator;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileGrinder;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePlacedItem;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePotentiometer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorComponent;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileStabilizedSpawner;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static final ModelRegistryHelper MODEL_HELPER = new ModelRegistryHelper();
    public static final DeferredRegister<AbstractHudElement> HUDS = DeferredRegister.create((ResourceKey)HudManager.HUD_TYPE, (String)"draconicevolution");
    public static final RegistryObject<ShieldHudElement> SHIELD_HUD = HUDS.register("shield_hud", ShieldHudElement::new);

    public static void init() {
        LOCK.lock();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientInit::clientSetupEvent);
        modBus.addListener(ClientInit::registerRenderers);
        modBus.addListener(ClientInit::onAddRenderLayers);
        modBus.addListener(ClientInit::onResourceReload);
        HUDS.register(modBus);
        ModularItemRenderOverrideHandler.init();
        CustomBossInfoHandler.init();
        OverlayRenderHandler.init();
        DEShaders.init();
        ClientEventHandler.init();
        AtlasTextureHelper.init(modBus);
        KeyBindings.init();
    }

    private static void clientSetupEvent(FMLClientSetupEvent event) {
        ClientInit.registerGuiFactories();
        ClientInit.registerItemRenderers();
        ClientInit.setupRenderLayers();
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
    }

    public static void onResourceReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ModuleTextures.getAtlasHolder());
        event.registerReloadListener((PreparableReloadListener)DEGuiTextures.getAtlasHolder());
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_GRINDER.get(), RenderTileGrinder::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_DRACONIUM_CHEST.get(), DraconiumChestTileRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_STORAGE_CORE.get(), RenderTileEnergyCore::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_ENERGY_PYLON.get(), RenderTileEnergyPylon::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CORE_STABILIZER.get(), RenderEnergyCoreStabilizer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_STABILIZED_SPAWNER.get(), RenderTileStabilizedSpawner::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_GENERATOR.get(), RenderTileGenerator::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_IO_CRYSTAL.get(), RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_RELAY_CRYSTAL.get(), RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_WIRELESS_CRYSTAL.get(), RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_REACTOR_CORE.get(), RenderTileReactorCore::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_REACTOR_INJECTOR.get(), RenderTileReactorComponent::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_REACTOR_STABILIZER.get(), RenderTileReactorComponent::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CRAFTING_CORE.get(), RenderTileFusionCraftingCore::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CRAFTING_INJECTOR.get(), RenderTileCraftingInjector::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_POTENTIOMETER.get(), RenderTilePotentiometer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_ENERGY_TRANSFUSER.get(), RenderTileEnergyTransfuser::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CHAOS_CRYSTAL.get(), RenderTileChaosCrystal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_DISLOCATOR_PEDESTAL.get(), RenderTileDislocatorPedestal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_PLACED_ITEM.get(), RenderTilePlacedItem::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_DISENCHANTER.get(), RenderTileDisenchanter::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CELESTIAL_MANIPULATOR.get(), RenderTileCelestialManipulator::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_ENTITY_DETECTOR.get(), RenderTileEntityDetector::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_DRACONIC_GUARDIAN.get(), DraconicGuardianRenderer::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_GUARDIAN_PROJECTILE.get(), GuardianProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_GUARDIAN_CRYSTAL.get(), GuardianCrystalRenderer::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get(), DraconicArrowRenderer::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_GUARDIAN_WITHER.get(), GuardianWitherRenderer::new);
    }

    private static void registerGuiFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_GENERATOR.get()), GeneratorGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_GRINDER.get()), GrinderGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_CONFIGURABLE_ITEM.get()), ConfigurableItemGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_MODULAR_ITEM.get()), ModularItemGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_DRACONIUM_CHEST.get()), DraconiumChestGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_ENERGY_CORE.get()), EnergyCoreGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_REACTOR.get()), ReactorGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_CELESTIAL_MANIPULATOR.get()), CelestialManipulatorGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_DISENCHANTER.get()), DisenchanterGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_FUSION_CRAFTING_CORE.get()), FusionCraftingCoreGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_FLOW_GATE.get()), FlowGateGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_ENTITY_DETECTOR.get()), EntityDetectorGui.Screen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DEContent.MENU_ENERGY_TRANSFUSER.get()), EnergyTransfuserGui.Screen::new);
    }

    private static void registerItemRenderers() {
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.CHAOS_SHARD.get())), "inventory"), (BakedModel)new RenderItemChaosShard((Item)DEContent.CHAOS_SHARD.get()));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.CHAOS_FRAG_LARGE.get())), "inventory"), (BakedModel)new RenderItemChaosShard((Item)DEContent.CHAOS_FRAG_LARGE.get()));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.CHAOS_FRAG_MEDIUM.get())), "inventory"), (BakedModel)new RenderItemChaosShard((Item)DEContent.CHAOS_FRAG_MEDIUM.get()));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.CHAOS_FRAG_SMALL.get())), "inventory"), (BakedModel)new RenderItemChaosShard((Item)DEContent.CHAOS_FRAG_SMALL.get()));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.MOB_SOUL.get())), "inventory"), (BakedModel)new RenderItemMobSoul());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_BASIC_IO_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.DRACONIUM));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_WYVERN_IO_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.WYVERN));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_DRACONIC_IO_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.DRACONIC));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_BASIC_RELAY_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.DRACONIUM));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_WYVERN_RELAY_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.WYVERN));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_DRACONIC_RELAY_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.DRACONIC));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_BASIC_WIRELESS_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.DRACONIUM));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_WYVERN_WIRELESS_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.WYVERN));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_DRACONIC_WIRELESS_CRYSTAL.get())), "inventory"), (BakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.DRACONIC));
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_DRACONIUM_CHEST.get())), "inventory"), (BakedModel)new RenderItemDraconiumChest());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_REACTOR_CORE.get())), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_REACTOR_STABILIZER.get())), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.ITEM_REACTOR_INJECTOR.get())), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.REACTOR_PRT_STAB_FRAME.get())), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.REACTOR_PRT_IN_ROTOR.get())), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.REACTOR_PRT_OUT_ROTOR.get())), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.REACTOR_PRT_ROTOR_FULL.get())), "inventory"), (BakedModel)new RenderItemReactorComponent());
        MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.REACTOR_PRT_FOCUS_RING.get())), "inventory"), (BakedModel)new RenderItemReactorComponent());
        if (DEConfig.fancyToolModels) {
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.PICKAXE_WYVERN.get())), "inventory"), (BakedModel)new RenderModularPickaxe(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.PICKAXE_DRACONIC.get())), "inventory"), (BakedModel)new RenderModularPickaxe(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.PICKAXE_CHAOTIC.get())), "inventory"), (BakedModel)new RenderModularPickaxe(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.AXE_WYVERN.get())), "inventory"), (BakedModel)new RenderModularAxe(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.AXE_DRACONIC.get())), "inventory"), (BakedModel)new RenderModularAxe(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.AXE_CHAOTIC.get())), "inventory"), (BakedModel)new RenderModularAxe(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.SHOVEL_WYVERN.get())), "inventory"), (BakedModel)new RenderModularShovel(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.SHOVEL_DRACONIC.get())), "inventory"), (BakedModel)new RenderModularShovel(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.SHOVEL_CHAOTIC.get())), "inventory"), (BakedModel)new RenderModularShovel(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.SWORD_WYVERN.get())), "inventory"), (BakedModel)new RenderModularSword(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.SWORD_DRACONIC.get())), "inventory"), (BakedModel)new RenderModularSword(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.SWORD_CHAOTIC.get())), "inventory"), (BakedModel)new RenderModularSword(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.BOW_WYVERN.get())), "inventory"), (BakedModel)new RenderModularBow(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.BOW_DRACONIC.get())), "inventory"), (BakedModel)new RenderModularBow(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.BOW_CHAOTIC.get())), "inventory"), (BakedModel)new RenderModularBow(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.STAFF_DRACONIC.get())), "inventory"), (BakedModel)new RenderModularStaff(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.STAFF_CHAOTIC.get())), "inventory"), (BakedModel)new RenderModularStaff(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.HOE_WYVERN.get())), "inventory"), (BakedModel)new RenderModularHoe(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.HOE_DRACONIC.get())), "inventory"), (BakedModel)new RenderModularHoe(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.HOE_CHAOTIC.get())), "inventory"), (BakedModel)new RenderModularHoe(TechLevel.CHAOTIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.CHESTPIECE_WYVERN.get())), "inventory"), (BakedModel)new RenderModularChestpiece(TechLevel.WYVERN));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.CHESTPIECE_DRACONIC.get())), "inventory"), (BakedModel)new RenderModularChestpiece(TechLevel.DRACONIC));
            MODEL_HELPER.register(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)((Item)DEContent.CHESTPIECE_CHAOTIC.get())), "inventory"), (BakedModel)new RenderModularChestpiece(TechLevel.CHAOTIC));
        }
    }

    private static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.GRINDER.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.GENERATOR.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.ENERGY_TRANSFUSER.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.PORTAL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.OVERWORLD_DRACONIUM_ORE.get()), renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.END_DRACONIUM_ORE.get()), renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.NETHER_DRACONIUM_ORE.get()), renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.DEEPSLATE_DRACONIUM_ORE.get()), renderType -> renderType == RenderType.m_110451_() || renderType == RenderType.m_110457_());
    }

    public static boolean deElytraVisible(ItemStack stack, LivingEntity entity) {
        if (ContributorHandler.shouldCancelElytra((LivingEntity)entity)) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof IModularArmor) {
            IModularArmor item2 = (IModularArmor)item;
            return item2.canElytraFlyBC(stack, entity);
        }
        if (BrandonsCore.equipmentManager != null) {
            IModularArmor item3;
            ItemStack curio = BrandonsCore.equipmentManager.findMatchingItem(e -> e.m_41720_() instanceof IModularArmor, entity);
            Item item4 = curio.m_41720_();
            return item4 instanceof IModularArmor && (item3 = (IModularArmor)item4).canElytraFlyBC(curio, entity);
        }
        return false;
    }

    private static void onAddRenderLayers(EntityRenderersEvent.AddLayers event) {
        for (String skin : event.getSkins()) {
            LivingEntityRenderer renderer = event.getSkin(skin);
            assert (renderer != null);
            renderer.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)renderer, event.getEntityModels()){

                public boolean shouldRender(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
                    return ClientInit.deElytraVisible(stack, entity);
                }
            });
        }
    }
}

