/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GroundTarget
extends DislocatorTarget {
    private Vector3 entityPos;
    private UUID entityUUID;

    public GroundTarget(ItemEntity entity) {
        super((ResourceKey<Level>)entity.m_9236_().m_46472_());
        this.entityUUID = entity.m_20148_();
        this.entityPos = Vector3.fromEntity((Entity)entity);
    }

    public GroundTarget(ResourceKey<Level> world) {
        super(world);
    }

    @Override
    public TargetPos getTargetPos(MinecraftServer server, UUID linkID, UUID sourceDislocatorID) {
        ServerLevel targetWorld = this.getTargetWorld(server);
        Entity entity = targetWorld.m_8791_(this.entityUUID);
        if (!(entity instanceof ItemEntity)) {
            AABB bb = new AABB(this.entityPos.pos().m_7918_(-1, -1, -1), this.entityPos.pos().m_7918_(1, 1, 1));
            bb.m_82400_(5.0);
            List items = targetWorld.m_45976_(ItemEntity.class, bb);
            for (ItemEntity item : items) {
                ItemStack stack = item.m_32055_();
                UUID id = BoundDislocator.getLinkId(stack);
                if (id == null || !id.equals(linkID)) continue;
                return new TargetPos((Entity)item);
            }
        } else {
            ItemStack stack = ((ItemEntity)entity).m_32055_();
            UUID id = BoundDislocator.getLinkId(stack);
            if (id != null && id.equals(linkID)) {
                return new TargetPos(entity);
            }
        }
        return null;
    }

    @Override
    protected void loadInternal(CompoundTag nbt) {
        super.loadInternal(nbt);
        this.entityPos = Vector3.fromNBT((CompoundTag)nbt);
        this.entityUUID = nbt.m_128342_("entity_uuid");
    }

    @Override
    public CompoundTag save(CompoundTag nbt) {
        this.entityPos.writeToNBT(nbt);
        nbt.m_128362_("entity_uuid", this.entityUUID);
        return super.save(nbt);
    }

    @Override
    public DislocatorTarget.TargetType getType() {
        return DislocatorTarget.TargetType.ON_GROUND;
    }
}

