/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.EnergyData;
import com.brandon3055.draconicevolution.lib.WTFException;
import net.minecraftforge.common.util.LazyOptional;

public class ModularOPStorage
extends OPStorage {
    private ModuleHost host;
    private TileBCore tile;
    private LazyOptional<ModuleHost> optionalHost;

    public ModularOPStorage(ModuleHost host, long baseCapacity) {
        super(baseCapacity);
        this.host = host;
        this.setReceiveOnly();
    }

    public ModularOPStorage(ModuleHost host, long baseCapacity, long baseTransfer) {
        super(baseCapacity, baseTransfer);
        this.host = host;
        this.setReceiveOnly();
    }

    public ModularOPStorage(ModuleHost host, long baseCapacity, long baseReceive, long baseExtract) {
        super(baseCapacity, baseReceive, baseExtract);
        this.host = host;
        this.setReceiveOnly();
    }

    public ModularOPStorage(TileBCore tile, long baseCapacity) {
        super(baseCapacity);
        this.tile = tile;
    }

    public ModularOPStorage(TileBCore tile, long baseCapacity, long baseTransfer) {
        super(baseCapacity, baseTransfer);
        this.tile = tile;
    }

    public ModularOPStorage(TileBCore tile, long baseCapacity, long baseReceive, long baseExtract) {
        super(baseCapacity, baseReceive, baseExtract);
        this.tile = tile;
    }

    private ModuleHost getHost() {
        if (this.host != null) {
            return this.host;
        }
        if (this.optionalHost == null) {
            this.optionalHost = this.tile.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        }
        return this.optionalHost.isPresent() ? (ModuleHost)this.optionalHost.orElseThrow(WTFException::new) : null;
    }

    public ModularOPStorage setIOMode(boolean allowExtract, boolean allowReceive) {
        return (ModularOPStorage)super.setIOMode(allowExtract, allowReceive);
    }

    public long getMaxOPStored() {
        ModuleHost host = this.getHost();
        if (host == null) {
            return super.getMaxOPStored();
        }
        return super.getMaxOPStored() + host.getModuleData(ModuleTypes.ENERGY_STORAGE, EnergyData.EMPTY).capacity();
    }

    public long maxReceive() {
        ModuleHost host = this.getHost();
        if (host == null) {
            return super.maxReceive();
        }
        return super.maxReceive() + host.getModuleData(ModuleTypes.ENERGY_STORAGE, EnergyData.EMPTY).transfer();
    }

    public long maxExtract() {
        ModuleHost host = this.getHost();
        if (host == null) {
            return super.maxExtract();
        }
        return super.maxExtract() + host.getModuleData(ModuleTypes.ENERGY_STORAGE, EnergyData.EMPTY).transfer();
    }

    public void markDirty() {
        super.markDirty();
        if (this.tile != null) {
            this.tile.m_6596_();
        }
    }
}

