/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class AutoFeedEntity
extends ModuleEntity<AutoFeedData> {
    private BooleanProperty consumeFood = new BooleanProperty("feed_mod.consume_food", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
    private float storedFood = 0.0f;

    public AutoFeedEntity(Module<AutoFeedData> module) {
        super(module);
        this.addProperty(this.consumeFood);
        this.savePropertiesToItem = true;
    }

    @Override
    public void tick(ModuleContext context) {
        LivingEntity entity;
        AutoFeedData data = (AutoFeedData)this.module.getData();
        if (context instanceof StackModuleContext && (entity = ((StackModuleContext)context).getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (entity.f_19797_ % 10 == 0 && ((StackModuleContext)context).isEquipped()) {
                if ((double)this.storedFood < data.foodStorage() && this.consumeFood.getValue()) {
                    for (ItemStack stack : player.m_150109_().f_35974_) {
                        double val;
                        double rem;
                        FoodProperties food;
                        if (stack.m_41619_() || !stack.m_41614_() || (food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)player)) == null || food.m_38744_() <= 0 || !food.m_38749_().isEmpty() || !((rem = (double)this.storedFood + (val = (double)((float)food.m_38744_() + food.m_38745_())) - data.foodStorage()) <= val * 0.25)) continue;
                        this.storedFood = (float)Math.min((double)this.storedFood + val, data.foodStorage());
                        entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.25f, 0.95f + entity.m_9236_().f_46441_.m_188501_() * 0.1f);
                        stack.m_41774_(1);
                        break;
                    }
                }
                FoodData foodStats = player.m_36324_();
                if (this.storedFood > 0.0f && (foodStats.m_38702_() < 20 || foodStats.m_38722_() < 20.0f)) {
                    double maxSat;
                    TechLevel tech = this.module.getModuleTechLevel();
                    double d = maxSat = entity.f_19797_ % 20 == 0 && tech == TechLevel.DRACONIC ? 20.0 : 1.0;
                    if (foodStats.m_38721_() && this.storedFood > 1.0f) {
                        foodStats.m_38707_((int)this.consumeFood(Math.min(1, 20 - foodStats.m_38702_())), 0.0f);
                    } else if ((double)foodStats.m_38722_() < maxSat && this.storedFood > 0.0f) {
                        foodStats.f_38697_ += (float)this.consumeFood(Math.min(1.0, maxSat - (double)foodStats.m_38722_()));
                    }
                }
            }
        }
    }

    private double consumeFood(double amount) {
        amount = Math.min(amount, (double)this.storedFood);
        this.storedFood = (float)((double)this.storedFood - amount);
        return amount;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, boolean renderStack, float partialTicks) {
        super.renderModule(parent, render, x, y, width, height, mouseX, mouseY, renderStack, partialTicks);
        AutoFeedData data = (AutoFeedData)this.module.getData();
        double progress = (double)this.storedFood / data.foodStorage();
        progress = (int)(progress * 21.0);
        progress = 20.0 - progress - 1.0;
        for (int i = 0; i < 10; ++i) {
            float size = (float)(width - 3) / 10.0f;
            render.texRect(BCGuiTextures.get((String)"bars/food_empty"), (double)((float)(x + 1) + (float)i * size), (double)((float)(y + height) - size - 2.0f), (double)(size + 1.0f), (double)(size + 1.0f));
            if (!(progress / 2.0 <= (double)i)) continue;
            if (progress / 2.0 < (double)i) {
                render.texRect(BCGuiTextures.get((String)"bars/food_full"), (double)((float)(x + 1) + (float)i * size), (double)((float)(y + height) - size - 2.0f), (double)(size + 1.0f), (double)(size + 1.0f));
                continue;
            }
            render.texRect(BCGuiTextures.get((String)"bars/food_half"), (double)((float)(x + 1) + (float)i * size), (double)((float)(y + height) - size - 2.0f), (double)(size + 1.0f), (double)(size + 1.0f));
        }
    }

    @Override
    public void addToolTip(List<Component> list) {
        list.add((Component)Component.m_237115_((String)"module.draconicevolution.auto_feed.stored").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"module.draconicevolution.auto_feed.stored.value", (Object[])new Object[]{(int)this.storedFood}).m_130940_(ChatFormatting.DARK_GREEN)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHostHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"module.draconicevolution.auto_feed.stored").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"module.draconicevolution.auto_feed.stored.value", (Object[])new Object[]{(int)this.storedFood}).m_130940_(ChatFormatting.DARK_GREEN)));
        }
    }

    @Override
    protected void readExtraData(CompoundTag tag) {
        this.storedFood = tag.m_128457_("food");
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag tag) {
        tag.m_128350_("food", this.storedFood);
        return tag;
    }
}

