/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ModuleProperties<T extends ModuleData<T>> {
    private final TechLevel techLevel;
    private int width;
    private int height;
    private T data;
    private Function<Module<T>, T> dataGenerator;

    public ModuleProperties(TechLevel techLevel, Function<Module<T>, T> dataGenerator) {
        this(techLevel, -1, -1, dataGenerator);
    }

    public ModuleProperties(TechLevel techLevel, int width, int height, Function<Module<T>, T> dataGenerator) {
        this.techLevel = techLevel;
        this.width = width;
        this.height = height;
        this.dataGenerator = dataGenerator;
    }

    public void reloadData(Module<T> module) {
        this.data = (ModuleData)this.dataGenerator.apply(module);
    }

    public T getData() {
        return this.data;
    }

    public int getWidth() {
        if (this.width == -1) {
            throw new IllegalStateException("Module dimensions have not been set! " + String.valueOf(this.getData()));
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height == -1) {
            throw new IllegalStateException("Module dimensions have not been set! " + String.valueOf(this.getData()));
        }
        return this.height;
    }

    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    public void loadDefaults(ModuleType<T> moduleType) {
        if (this.width == -1 && moduleType.getDefaultWidth() != -1) {
            this.width = moduleType.getDefaultWidth();
        }
        if (this.height == -1 && moduleType.getDefaultHeight() != -1) {
            this.height = moduleType.getDefaultHeight();
        }
    }

    public void addStats(List<Component> toolTip, Module<?> module, ModuleContext context) {
        toolTip.add((Component)Component.m_237115_((String)"module.draconicevolution.module_type").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)module.getType().getDisplayName().m_6881_().m_130940_(this.techLevel.getTextColour())));
        toolTip.add((Component)Component.m_237115_((String)"module.draconicevolution.grid_size").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(this.getWidth() + "x" + this.getHeight())).m_130940_(ChatFormatting.DARK_GREEN)));
        HashMap<Component, Component> map = new HashMap<Component, Component>();
        this.getData().addInformation(map, context);
        map.forEach((name, value) -> {
            if (value == null) {
                toolTip.add((Component)name.m_6879_().m_130940_(ChatFormatting.GRAY));
            } else {
                toolTip.add((Component)name.m_6879_().m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_130946_(String.valueOf(ChatFormatting.DARK_GREEN) + value.m_6879_().getString().replace("\n", " ")));
            }
        });
    }
}

