/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;

public class LabelliaBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int PICKUP_RANGE = 0;
    private static final int RENAME_RANGE = 2;
    private static final int COST = 500;

    public LabelliaBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.LABELLIA, pos, state);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 16772739;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.f_58857_.f_46443_ && this.redstoneSignal == 0 && this.getMana() >= 500) {
            BlockPos effPos = this.getEffectivePos();
            BlockPos realPos = this.m_58899_();
            int x = effPos.m_123341_();
            int y = effPos.m_123342_();
            int z = effPos.m_123343_();
            for (ItemEntity nameTagEnt : this.f_58857_.m_6443_(ItemEntity.class, new AABB(realPos.m_7918_(0, 0, 0), realPos.m_7918_(1, 1, 1)), EntitySelector.f_20402_)) {
                ItemStack nameTag;
                if (!DelayHelper.canInteractWith(this, nameTagEnt) || !(nameTag = nameTagEnt.m_32055_()).m_150930_(Items.f_42656_) || !nameTag.m_41788_()) continue;
                AABB renameArea = new AABB((double)(x - 2), (double)y, (double)(z - 2), (double)(x + 2 + 1), (double)(y + 1), (double)(z + 2 + 1));
                Component name = nameTag.m_41786_();
                List nameableEntities = this.f_58857_.m_6443_(LivingEntity.class, renameArea, EntitySelector.f_20402_.and(e -> !name.equals(e.m_7770_()) && !(e instanceof Player)));
                List nameableItems = this.f_58857_.m_6443_(ItemEntity.class, renameArea, i -> DelayHelper.canInteractWith(this, i) && i != nameTagEnt && !name.equals(i.m_32055_().m_41786_()));
                if (nameableItems.isEmpty() && nameableEntities.isEmpty()) continue;
                for (LivingEntity e2 : nameableEntities) {
                    e2.m_6593_(name);
                    if (!(e2 instanceof Mob)) continue;
                    Mob mob = (Mob)e2;
                    mob.m_21530_();
                }
                for (ItemEntity i2 : nameableItems) {
                    i2.m_32055_().m_41714_(name);
                    EntityHelper.syncItem(i2);
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123751_, i2.m_20185_(), i2.m_20186_(), i2.m_20189_(), 3, 0.0, 0.0, 0.0, 0.0);
                }
                this.addMana(-500);
                EntityHelper.shrinkItem(nameTagEnt);
                this.f_58857_.m_6263_(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, BotaniaSounds.labellia, SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 2);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.m_58899_(), 0);
    }

    @Override
    public int getMaxMana() {
        return 6000;
    }
}

