/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;
import vazkii.botania.common.helper.FilterHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class CorporeaFunnelBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaRequestor {
    private static final int[] ROTATION_TO_STACK_SIZE = new int[]{1, 2, 4, 8, 16, 32, 48, 64};

    public CorporeaFunnelBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_FUNNEL, pos, state);
    }

    public void doRequest() {
        ItemStack stack;
        WeightedRandomList<FilterHelper.WeightedItemStack> filter;
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !(filter = this.getFilter()).m_146337_() && !(stack = filter.m_216829_(this.f_58857_.f_46441_).map(FilterHelper.WeightedItemStack::stack).orElse(ItemStack.f_41583_)).m_41619_()) {
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(stack, true);
            this.doCorporeaRequest(matcher, stack.m_41613_(), spark, null);
        }
    }

    public WeightedRandomList<FilterHelper.WeightedItemStack> getFilter() {
        ArrayList filter = new ArrayList();
        for (Direction dir : Direction.values()) {
            List frames = this.f_58857_.m_45976_(ItemFrame.class, new AABB(this.f_58858_.m_121945_(dir), this.f_58858_.m_121945_(dir).m_7918_(1, 1, 1)));
            for (ItemFrame frame : frames) {
                List<ItemStack> filterStacks;
                Direction orientation = frame.m_6350_();
                if (orientation != dir || (filterStacks = FilterHelper.getFilterItems(frame)).isEmpty()) continue;
                int stackSize = ROTATION_TO_STACK_SIZE[frame.m_31823_()];
                filterStacks.stream().map(s -> FilterHelper.WeightedItemStack.of(s.m_255036_(stackSize), s.m_41613_())).forEach(filter::add);
            }
        }
        return WeightedRandomList.m_146328_(filter);
    }

    @Override
    public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable LivingEntity entity) {
        BlockPos invPos = this.getInvPos();
        List<ItemStack> stacks = CorporeaHelper.instance().requestItem(request, count, spark, entity, true).stacks();
        spark.onItemsRequested(stacks);
        for (ItemStack reqStack : stacks) {
            if (invPos != null && XplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, invPos, Direction.UP, reqStack, true).m_41619_()) {
                InventoryHelper.checkEmpty(XplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, invPos, Direction.UP, reqStack, false));
                continue;
            }
            ItemEntity item = new ItemEntity(this.f_58857_, spark.entity().m_20185_(), spark.entity().m_20186_(), spark.entity().m_20189_(), reqStack);
            this.f_58857_.m_7967_((Entity)item);
        }
    }

    @Nullable
    private BlockPos getInvPos() {
        BlockPos downOne = this.f_58858_.m_7495_();
        if (XplatAbstractions.INSTANCE.hasInventory(this.f_58857_, downOne, Direction.UP)) {
            return downOne;
        }
        BlockPos downTwo = this.f_58858_.m_6625_(2);
        if (XplatAbstractions.INSTANCE.hasInventory(this.f_58857_, downTwo, Direction.UP)) {
            return downTwo;
        }
        return null;
    }
}

