/*
 * Decompiled with CFR 0.152.
 */
package com.aylanj123.usefulladders.mixin;

import com.aylanj123.usefulladders.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LadderBlock.class})
public abstract class LadderBlockMixin {
    @Shadow
    @Final
    public static DirectionProperty f_54337_;
    @Shadow
    @Final
    public static BooleanProperty f_54338_;
    @Unique
    private static final VoxelShape NEW_EAST_AABB;
    @Unique
    private static final VoxelShape NEW_WEST_AABB;
    @Unique
    private static final VoxelShape NEW_SOUTH_AABB;
    @Unique
    private static final VoxelShape NEW_NORTH_AABB;

    @Shadow
    protected abstract boolean m_54348_(BlockGetter var1, BlockPos var2, Direction var3);

    @Overwrite
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)f_54337_)) {
            case Direction.NORTH -> NEW_NORTH_AABB;
            case Direction.SOUTH -> NEW_SOUTH_AABB;
            case Direction.WEST -> NEW_WEST_AABB;
            default -> NEW_EAST_AABB;
        };
    }

    @Overwrite
    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        boolean supportBehind = this.usefulLadders$hasSturdySupport(pState, pLevel, pPos);
        if (supportBehind) {
            return true;
        }
        if (Config.maxStress == 0 && Config.maxHang == 0) {
            return false;
        }
        if (Config.maxStress == 0) {
            return this.usefulLadders$checkForHangingSupport(pState, pLevel, pPos);
        }
        if (Config.maxHang == 0) {
            return this.usefulLadders$checkForStressedSupport(pState, pLevel, pPos);
        }
        if (Config.maxStress == -1) {
            return this.usefulLadders$checkForHangingSupport(pState, pLevel, pPos) || this.usefulLadders$checkForStressedSupport(pState, pLevel, pPos);
        }
        if (Config.maxHang == -1) {
            return this.usefulLadders$checkForStressedSupport(pState, pLevel, pPos) || this.usefulLadders$checkForHangingSupport(pState, pLevel, pPos);
        }
        if (Config.maxStress < Config.maxHang) {
            return this.usefulLadders$checkForStressedSupport(pState, pLevel, pPos) || this.usefulLadders$checkForHangingSupport(pState, pLevel, pPos);
        }
        return this.usefulLadders$checkForHangingSupport(pState, pLevel, pPos) || this.usefulLadders$checkForStressedSupport(pState, pLevel, pPos);
    }

    @Overwrite
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!(pFacing.m_122424_() != pState.m_61143_((Property)f_54337_) && pFacing != Direction.DOWN && pFacing != Direction.UP || pState.m_60710_((LevelReader)pLevel, pCurrentPos))) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)pState.m_61143_((Property)f_54338_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return pState;
    }

    @Unique
    public boolean usefulLadders$hasSturdySupport(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54337_);
        return this.m_54348_((BlockGetter)level, pos.m_121945_(direction.m_122424_()), direction);
    }

    @Unique
    public boolean usefulLadders$checkForHangingSupport(BlockState ladderState, LevelReader level, BlockPos lastPos) {
        return this.usefulLadders$checkForHangingSupport(0, ladderState, level, lastPos);
    }

    @Unique
    public boolean usefulLadders$checkForHangingSupport(int i, BlockState ladderState, LevelReader level, BlockPos lastPos) {
        if (Config.maxHang != -1 && ++i > Config.maxHang) {
            return false;
        }
        BlockPos posToCheck = lastPos.m_7494_();
        BlockState stateToCheck = level.m_8055_(posToCheck);
        if (stateToCheck.m_60734_() != Blocks.f_50155_ || stateToCheck.m_61143_((Property)LadderBlock.f_54337_) != ladderState.m_61143_((Property)LadderBlock.f_54337_)) {
            return false;
        }
        if (!this.usefulLadders$hasSturdySupport(ladderState, level, posToCheck)) {
            return this.usefulLadders$checkForHangingSupport(i, ladderState, level, posToCheck);
        }
        return true;
    }

    @Unique
    public boolean usefulLadders$checkForStressedSupport(BlockState ladderState, LevelReader level, BlockPos lastPos) {
        return this.usefulLadders$checkForStressedSupport(0, ladderState, level, lastPos);
    }

    @Unique
    public boolean usefulLadders$checkForStressedSupport(int i, BlockState ladderState, LevelReader level, BlockPos lastPos) {
        if (Config.maxStress != -1 && ++i > Config.maxStress) {
            return false;
        }
        BlockPos posToCheck = lastPos.m_7495_();
        BlockState stateToCheck = level.m_8055_(posToCheck);
        if (stateToCheck.m_60734_() != Blocks.f_50155_ || stateToCheck.m_61143_((Property)LadderBlock.f_54337_) != ladderState.m_61143_((Property)LadderBlock.f_54337_)) {
            return false;
        }
        if (!this.usefulLadders$hasSturdySupport(ladderState, level, posToCheck)) {
            return this.usefulLadders$checkForStressedSupport(i, ladderState, level, posToCheck);
        }
        return true;
    }

    static {
        NEW_EAST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
        NEW_WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
        NEW_SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)3.0);
        NEW_NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)15.0);
    }
}

