/*
 * Decompiled with CFR 0.152.
 */
package com.aylanj123.usefulladders.items;

import com.aylanj123.usefulladders.Config;
import com.aylanj123.usefulladders.Helpers;
import com.aylanj123.usefulladders.LangKeys;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class RopeLadder
extends Item {
    public RopeLadder(Item.Properties properties) {
        super(properties.m_41497_(Rarity.COMMON).m_41487_(64));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        if (pContext.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Level level = pContext.m_43725_();
        Direction horizontalOpposite = pContext.m_8125_().m_122424_();
        Direction face = pContext.m_43719_();
        BlockPos aimedPos = pContext.m_8083_();
        BlockPos pos = aimedPos.m_121945_(face);
        Direction ladderDirection = face == Direction.UP || face == Direction.DOWN ? horizontalOpposite : face;
        BlockState ladderState = (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)ladderDirection);
        Boolean aimedAtLadder = level.m_8055_(aimedPos).m_60734_() == Blocks.f_50155_;
        if (!aimedAtLadder.booleanValue() && Blocks.f_50155_.m_7898_(ladderState, (LevelReader)level, pos)) {
            BlockState stateToReplace = level.m_8055_(pos);
            if (stateToReplace.m_60734_() == Blocks.f_49990_) {
                ladderState.m_61124_((Property)LadderBlock.f_54338_, (Comparable)Boolean.valueOf(true));
            }
            level.m_7731_(pos, ladderState, 11);
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, 1);
            pContext.m_43725_().m_5594_(null, pos, SoundEvents.f_12023_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.consume(pContext, pos);
        } else if (aimedAtLadder.booleanValue()) {
            Helpers.RecursiveResult result = Helpers.placeLadder(aimedPos, level, level.m_8055_(aimedPos), Direction.DOWN);
            if (result.success) {
                this.consume(pContext, result.finalPos);
            }
        }
        return InteractionResult.CONSUME;
    }

    private void consume(UseOnContext cx, BlockPos pos) {
        ItemStack stack = cx.m_43722_();
        stack.m_41764_(stack.m_41613_() - 1);
        Random rdm = new Random();
        if (rdm.nextFloat() < Config.recoveryChance) {
            if (cx.m_43723_() != null && cx.m_43723_().m_7500_()) {
                return;
            }
            cx.m_43725_().m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((cx.m_43725_().f_46441_.m_188501_() - cx.m_43725_().f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            ItemStack string = new ItemStack((ItemLike)Items.f_42401_, 1);
            if (Config.inventoryRecovery && cx.m_43723_() != null) {
                cx.m_43723_().m_150109_().m_36054_(string);
            } else {
                ItemEntity entity = new ItemEntity(cx.m_43725_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), string);
                cx.m_43725_().m_7967_((Entity)entity);
            }
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return Component.m_237115_((String)LangKeys.ITEM_ROPE_LADDER.key());
    }
}

