/*
 * Decompiled with CFR 0.152.
 */
package com.aylanj123.usefulladders.eventhandler;

import com.aylanj123.usefulladders.UsefulLaddersMod;
import com.aylanj123.usefulladders.datagen.ItemModels;
import com.aylanj123.usefulladders.datagen.Recipes;
import com.aylanj123.usefulladders.datagen.language.EnglishLanguageProvider;
import com.aylanj123.usefulladders.datagen.language.GermanLanguageProvider;
import com.aylanj123.usefulladders.datagen.language.PortugueseLanguageProvider;
import com.aylanj123.usefulladders.datagen.language.SpanishLanguageProvider;
import com.aylanj123.usefulladders.datagen.language.SwedishLanguageProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CommonEventHandler {

    @Mod.EventBusSubscriber(modid="useful_ladders", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonModEvents {
        private static final List<String> englishLocales = new ArrayList<String>(List.of("en_us", "en_nz", "en_gb", "en_ca", "en_au"));
        private static final List<String> spanishLocales = new ArrayList<String>(List.of("es_ve", "es_uy", "es_mx", "es_es", "es_ec", "es_cl", "es_ar"));
        private static final List<String> germanLocales = new ArrayList<String>(List.of("de_de", "de_at", "de_ch", "nds_de"));
        private static final List<String> portugueseLocales = new ArrayList<String>(List.of("pt_pt", "pt_br"));

        @SubscribeEvent
        static void gatherData(GatherDataEvent event) {
            UsefulLaddersMod.LOGGER.info("Generating new data");
            DataGenerator gen = event.getGenerator();
            PackOutput output = gen.getPackOutput();
            ExistingFileHelper helper = event.getExistingFileHelper();
            CompletableFuture lookUp = event.getLookupProvider();
            for (String locale : englishLocales) {
                gen.addProvider(event.includeClient(), (DataProvider)new EnglishLanguageProvider(output, locale));
            }
            for (String locale : spanishLocales) {
                gen.addProvider(event.includeClient(), (DataProvider)new SpanishLanguageProvider(output, locale));
            }
            for (String locale : germanLocales) {
                gen.addProvider(event.includeClient(), (DataProvider)new GermanLanguageProvider(output, locale));
            }
            for (String locale : portugueseLocales) {
                gen.addProvider(event.includeClient(), (DataProvider)new PortugueseLanguageProvider(output, locale));
            }
            gen.addProvider(event.includeClient(), (DataProvider)new SwedishLanguageProvider(output, "sv_se"));
            gen.addProvider(event.includeServer(), (DataProvider)new Recipes(output));
            gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, helper));
        }
    }
}

