/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Stack;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.GenericTreeConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.exceptions.TreeTooBigException;
import me.pandamods.fallingtrees.registry.SoundRegistry;
import me.pandamods.pandalib.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;

public class GenericTree
implements TreeType {
    @Override
    public boolean isTreeStem(class_2680 blockState) {
        return this.getConfig().logFilter.isValid(blockState);
    }

    @Override
    public void onTreeTick(TreeEntity entity) {
        if (Services.GAME.isClient()) {
            ClientConfig clientConfig = FallingTreesConfig.getClientConfig();
            if (entity.field_6012 == 1 && clientConfig.soundSettings.enabled) {
                entity.method_37908().method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)SoundRegistry.TREE_FALL.get(), class_3419.field_15245, clientConfig.soundSettings.startVolume, 1.0f, true);
            }
            if (entity.field_6012 == (int)(clientConfig.animation.fallAnimLength * 20.0f) - 5 && clientConfig.soundSettings.enabled) {
                entity.method_37908().method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)SoundRegistry.TREE_IMPACT.get(), class_3419.field_15245, clientConfig.soundSettings.endVolume, 1.0f, true);
            }
        }
    }

    @Override
    public TreeData gatherTreeData(class_2338 blockPos, class_1937 level, class_1657 player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.method_6047())) {
            return null;
        }
        blockPos = blockPos.method_10062();
        TreeData.Builder builder = TreeData.builder();
        if (!this.isLogBlock(level.method_8320(blockPos))) {
            return null;
        }
        Set<class_2338> logs = this.gatherLogs(level, blockPos);
        if (logs.isEmpty()) {
            return null;
        }
        HashSet<class_2338> leaves = new HashSet<class_2338>();
        for (class_2338 logPos2 : logs) {
            leaves.addAll(this.gatherLeavesAroundLog(level, logPos2));
        }
        if (leaves.isEmpty()) {
            return null;
        }
        Set<class_2338> adjacent = this.gatherAdjacentBlocks(level, logs, leaves);
        HashSet<class_2338> allBlocks = new HashSet<class_2338>(logs);
        allBlocks.addAll(leaves);
        allBlocks.addAll(adjacent);
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        for (class_2338 block : allBlocks) {
            class_2680 blockState = level.method_8320(block);
            if (!(level instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)level;
            List items = class_2248.method_9609((class_2680)blockState, (class_3218)serverLevel, (class_2338)block, null, (class_1297)player, (class_1799)player.method_6047());
            drops.addAll(items);
        }
        return builder.addBlocks(allBlocks).setToolDamage(logs.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)logs.size()).addDrops(drops).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)logs.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).addAwardedStats(logs.stream().map(logPos -> {
            class_2680 blockState = level.method_8320(logPos);
            return class_3468.field_15427.method_14956((Object)blockState.method_26204());
        }).toList()).build();
    }

    private Set<class_2338> gatherLogs(class_1937 level, class_2338 startPos) {
        HashSet<class_2338> logs = new HashSet<class_2338>();
        LinkedList<class_2338> toVisit = new LinkedList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            class_2338 current = (class_2338)toVisit.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            if (!this.isLogBlock(currentState)) continue;
            logs.add(current);
            if (logs.size() > this.getConfig().algorithm.maxLogAmount) {
                throw new TreeTooBigException(current, level);
            }
            for (class_2338 offset : class_2338.method_10094((int)-1, (int)0, (int)-1, (int)1, (int)1, (int)1)) {
                class_2338 neighbor = current.method_10081((class_2382)offset);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return logs;
    }

    private Set<class_2338> gatherLeavesAroundLog(class_1937 level, class_2338 logPos) {
        HashSet<class_2338> leaves = new HashSet<class_2338>();
        LinkedList<BlockSearchNode> toVisit = new LinkedList<BlockSearchNode>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighbor = logPos.method_10093(direction);
            toVisit.add(new BlockSearchNode(neighbor, 1));
        }
        while (!toVisit.isEmpty()) {
            BlockSearchNode node = (BlockSearchNode)toVisit.poll();
            class_2338 current = node.position;
            class_2680 currentState = level.method_8320(current);
            OptionalInt optionalDistanceAt = class_2397.method_49817((class_2680)currentState);
            if (node.distance != optionalDistanceAt.orElse(0) || visited.contains(current) || node.distance > this.getConfig().algorithm.maxLeavesRadius) continue;
            visited.add(current);
            if (!this.isLeafBlock(currentState)) continue;
            leaves.add(current);
            for (class_2350 direction : class_2350.values()) {
                class_2338 nextPos = current.method_10093(direction);
                if (visited.contains(nextPos)) continue;
                toVisit.add(new BlockSearchNode(nextPos, node.distance + 1));
            }
        }
        return leaves;
    }

    private Set<class_2338> gatherAdjacentBlocks(class_1937 level, Set<class_2338> logs, Set<class_2338> leaves) {
        HashSet<class_2338> adjacentBlocks = new HashSet<class_2338>();
        HashSet<class_2338> allTreeBlocks = new HashSet<class_2338>(logs);
        allTreeBlocks.addAll(leaves);
        for (class_2338 blockPos : allTreeBlocks) {
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = blockPos.method_10093(dir);
                class_2680 neighborState = level.method_8320(neighbor);
                if (neighborState.method_27852(class_2246.field_10597)) {
                    adjacentBlocks.addAll(this.gatherVines(level, neighbor));
                    continue;
                }
                if (neighborState.method_27852(class_2246.field_20421)) {
                    adjacentBlocks.add(neighbor);
                    continue;
                }
                if (!neighborState.method_27852(class_2246.field_10302)) continue;
                adjacentBlocks.add(neighbor);
            }
        }
        return adjacentBlocks;
    }

    private Set<class_2338> gatherVines(class_1937 level, class_2338 startPos) {
        HashSet<class_2338> vines = new HashSet<class_2338>();
        Stack<class_2338> toVisit = new Stack<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        toVisit.push(startPos);
        while (!toVisit.isEmpty()) {
            class_2338 current = (class_2338)toVisit.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            if (!currentState.method_27852(class_2246.field_10597)) continue;
            vines.add(current);
            class_2338 neighbor = current.method_10074();
            if (visited.contains(neighbor)) continue;
            toVisit.push(neighbor);
        }
        return vines;
    }

    private boolean isLogBlock(class_2680 blockState) {
        return this.getConfig().logFilter.isValid(blockState);
    }

    private boolean isLeafBlock(class_2680 blockState) {
        if (this.getConfig().algorithm.shouldIgnorePersistentLeaves && blockState.method_28498((class_2769)class_2741.field_12514) && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12514)).booleanValue()) {
            return false;
        }
        return this.getConfig().leavesFilter.isValid(blockState);
    }

    public GenericTreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.genericTree;
    }

    private record BlockSearchNode(class_2338 position, int distance) {
    }
}

