/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.registry.TreeRegistry;
import me.pandamods.fallingtrees.utils.BlockMapEntityData;
import me.pandamods.fallingtrees.utils.ItemListEntityData;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class TreeEntity
extends class_1297 {
    public static final class_2940<Map<class_2338, class_2680>> BLOCKS = class_2945.method_12791(TreeEntity.class, BlockMapEntityData.BLOCK_MAP);
    public static final class_2940<List<class_1799>> DROPS = class_2945.method_12791(TreeEntity.class, ItemListEntityData.ITEM_LIST);
    public static final class_2940<class_2338> ORIGIN_POS = class_2945.method_12791(TreeEntity.class, (class_2941)class_2943.field_13324);
    public static final class_2940<class_2350> FALL_DIRECTION = class_2945.method_12791(TreeEntity.class, (class_2941)class_2943.field_13321);
    public static final class_2940<String> TREE_TYPE_LOCATION = class_2945.method_12791(TreeEntity.class, (class_2941)class_2943.field_13326);
    public class_1297 owner = null;
    public TreeType treeType = null;

    public TreeEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5985 = true;
    }

    public void setData(class_1297 owner, TreeType tree, class_2338 originBlock, List<class_2338> blockPosList, List<class_1799> drops) {
        this.owner = owner;
        this.treeType = tree;
        class_2960 treeTypeLocation = TreeRegistry.getTreeLocation(tree);
        if (treeTypeLocation != null) {
            this.method_5841().method_12778(TREE_TYPE_LOCATION, (Object)treeTypeLocation.toString());
        }
        HashMap<class_2338, class_2680> blockPosMap = new HashMap<class_2338, class_2680>();
        for (class_2338 pos : blockPosList) {
            blockPosMap.put(pos.method_10062().method_10059((class_2382)originBlock), this.method_37908().method_8320(pos));
        }
        this.method_5841().method_12778(ORIGIN_POS, (Object)originBlock);
        this.method_5841().method_12778(BLOCKS, blockPosMap);
        this.method_5841().method_12778(DROPS, drops);
        this.method_5841().method_12778(FALL_DIRECTION, (Object)class_2350.method_10150((double)(-Math.toDegrees((double)Math.atan2((double)(owner.method_23317() - (double)originBlock.method_10263()), (double)(owner.method_23321() - (double)originBlock.method_10260()))))).method_10153());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(BLOCKS, Collections.emptyMap());
        builder.method_56912(DROPS, Collections.emptyList());
        builder.method_56912(ORIGIN_POS, (Object)new class_2338(0, 0, 0));
        builder.method_56912(FALL_DIRECTION, (Object)class_2350.field_11043);
        builder.method_56912(TREE_TYPE_LOCATION, (Object)"");
    }

    public void method_5674(class_2940<?> dataAccessor) {
        super.method_5674(dataAccessor);
        if (TREE_TYPE_LOCATION.equals(dataAccessor)) {
            this.treeType = TreeRegistry.getTree(class_2960.method_12829((String)((String)this.method_5841().method_12789(TREE_TYPE_LOCATION))));
        }
    }

    protected void method_5749(class_2487 compound) {
    }

    protected void method_5652(class_2487 compound) {
    }

    public void method_5773() {
        super.method_5773();
        this.treeType.onTreeTick(this);
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(1.0, -0.5, 1.0));
        }
        if (this.field_6012 >= this.getMaxLifeTimeTick()) {
            if (!this.method_37908().method_8608()) {
                this.dropItems();
            }
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    private void dropItems() {
        for (class_1799 stack : (List)this.method_5841().method_12789(DROPS)) {
            double deltaX = class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.1, (double)0.1);
            double deltaY = 0.25;
            double deltaZ = class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.1, (double)0.1);
            class_1542 entity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318() + (double)(class_1299.field_6052.method_17686() / 2.0f), this.method_23321(), stack, deltaX, deltaY, deltaZ);
            entity.method_6988();
            this.method_37908().method_8649((class_1297)entity);
        }
    }

    public int getMaxLifeTimeTick() {
        return (int)(FallingTreesConfig.getCommonConfig().treeLifetimeLength * 20.0f);
    }

    public float getLifetime(float partialTick) {
        return ((float)this.field_6012 + partialTick) / 20.0f;
    }

    public Map<class_2338, class_2680> getBlocks() {
        return (Map)this.method_5841().method_12789(BLOCKS);
    }

    public class_2338 getOriginPos() {
        return (class_2338)this.method_5841().method_12789(ORIGIN_POS);
    }

    @NotNull
    public class_2350 method_5735() {
        return (class_2350)this.method_5841().method_12789(FALL_DIRECTION);
    }

    public TreeType getTreeType() {
        return this.treeType;
    }
}

