/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.client.render;

import java.util.Map;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.utils.RenderUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class TreeRenderer
extends class_897<TreeEntity> {
    public TreeRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public ClientConfig getConfig() {
        return FallingTreesConfig.getClientConfig((class_1657)class_310.method_1551().field_1724);
    }

    public void render(TreeEntity entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        TreeType tree = entity.treeType;
        if (tree == null) {
            return;
        }
        poseStack.method_22903();
        Map<class_2338, class_2680> blocks = entity.getBlocks();
        float fallAnimLength = this.getConfig().animation.fallAnimLength;
        float bounceHeight = this.getConfig().animation.bounceAngleHeight;
        float bounceAnimLength = this.getConfig().animation.bounceAnimLength;
        float time = (float)((double)entity.getLifetime(partialTick) * 1.5707963267948966 / (double)fallAnimLength);
        float fallAnim = this.bumpCos(time) * 90.0f;
        float bounceAnim = this.bumpSin((float)(((double)time - 1.5707963267948966) / (double)(bounceAnimLength / (fallAnimLength * 2.0f)))) * bounceHeight;
        float animation = fallAnim + bounceAnim - 90.0f;
        class_2350 direction = entity.method_5735().method_10153();
        float distance = this.getDistance(tree, blocks, direction.method_10153());
        Vector3f pivot = new Vector3f(0.0f, 0.0f, 0.5f + distance);
        pivot.rotateY(Math.toRadians((float)(-direction.method_10144())));
        poseStack.method_46416(-pivot.x, 0.0f, -pivot.z);
        Vector3f vector = new Vector3f(Math.toRadians((float)animation), 0.0f, 0.0f);
        vector.rotateY(Math.toRadians((float)(-direction.method_10144())));
        Quaternionf quaternion = new Quaternionf().identity().rotateX(vector.x).rotateZ(vector.z);
        poseStack.method_22907(quaternion);
        class_1937 level = entity.method_37908();
        poseStack.method_46416(pivot.x, 0.0f, pivot.z);
        poseStack.method_22904(-0.5, 0.0, -0.5);
        blocks.forEach((blockPos, blockState) -> {
            poseStack.method_22903();
            poseStack.method_46416((float)blockPos.method_10263(), (float)blockPos.method_10264(), (float)blockPos.method_10260());
            blockPos = blockPos.method_10081((class_2382)entity.getOriginPos());
            RenderUtils.renderSingleBlock(poseStack, blockState, blockPos, (class_1920)level, bufferSource, packedLight);
            poseStack.method_22909();
        });
        poseStack.method_22909();
    }

    private float getDistance(TreeType tree, Map<class_2338, class_2680> blocks, class_2350 direction) {
        float distance = 0.0f;
        class_2338 currentPos = new class_2338(0, 0, 0);
        class_2338 next = currentPos.method_10093(direction);
        while (blocks.containsKey(next) && tree.isTreeStem(blocks.get(next))) {
            currentPos = next;
            next = currentPos.method_10093(direction);
            distance += 1.0f;
        }
        class_2680 blockState = blocks.get(currentPos);
        if (blockState.method_49228()) {
            return distance - 0.5f;
        }
        class_265 shape = blockState.method_26220((class_1922)class_310.method_1551().field_1687, currentPos);
        if (shape.method_1110()) {
            shape = blockState.method_26218((class_1922)class_310.method_1551().field_1687, currentPos);
        }
        if (!shape.method_1110()) {
            class_238 bounds = shape.method_1107();
            switch (direction) {
                case field_11039: {
                    distance -= (float)bounds.field_1323;
                    break;
                }
                case field_11034: {
                    distance -= (float)(1.0 - bounds.field_1320);
                    break;
                }
                case field_11035: {
                    distance -= (float)bounds.field_1321;
                    break;
                }
                case field_11043: {
                    distance -= (float)(1.0 - bounds.field_1324);
                }
            }
        } else {
            distance -= 1.0f;
        }
        return distance;
    }

    private float bumpCos(float time) {
        return (float)Math.max((double)0.0, (double)Math.cos((double)Math.clamp((double)(-java.lang.Math.PI), (double)java.lang.Math.PI, (double)time)));
    }

    private float bumpSin(float time) {
        return (float)Math.max((double)0.0, (double)Math.sin((double)Math.clamp((double)(-java.lang.Math.PI), (double)java.lang.Math.PI, (double)time)));
    }

    public class_2960 getTextureLocation(TreeEntity entity) {
        return null;
    }
}

