/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.api;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.exceptions.TreeException;
import me.pandamods.fallingtrees.registry.EntityRegistry;
import me.pandamods.fallingtrees.registry.TreeRegistry;
import me.pandamods.pandalib.utils.RunUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3468;
import org.slf4j.Logger;

public class TreeHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<UUID, TreeSpeed> TREE_SPEED_CACHES = new ConcurrentHashMap<UUID, TreeSpeed>();

    public static boolean destroyTree(class_1937 level, class_2338 blockPos, class_1657 player) {
        if (level.method_8608()) {
            return false;
        }
        class_2680 blockState = level.method_8320(blockPos);
        TreeType tree = TreeRegistry.getTree(blockState);
        if (tree == null) {
            return false;
        }
        TreeData data = TreeHandler.tryGatherTreeData(tree, blockPos, level, player, false);
        if (data == null) {
            return false;
        }
        List<class_2338> blocks = data.blocks();
        TreeEntity entity = new TreeEntity((class_1299)EntityRegistry.TREE.get(), level);
        entity.method_5814((double)blockPos.method_10263() + 0.5, blockPos.method_10264(), (double)blockPos.method_10260() + 0.5);
        entity.setData((class_1297)player, tree, blockPos, blocks, data.drops());
        player.method_7322(FallingTreesConfig.getCommonConfig().disableExtraFoodExhaustion ? 1.0f : data.foodExhaustionModifier().getExhaustion(0.005f));
        if (player.method_6047().method_7963()) {
            player.method_6047().method_7970(FallingTreesConfig.getCommonConfig().disableExtraToolDamage ? 1 : data.toolDamage(), (class_1309)player, class_1304.field_6173);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)player.method_6047().method_7909()));
        data.awardedStats().forEach(awardedStat -> player.method_7342(awardedStat.stat(), awardedStat.amount()));
        HashMap<class_2338, class_2680> blockStates = new HashMap<class_2338, class_2680>();
        class_2680 air = class_2246.field_10124.method_9564();
        for (class_2338 pos2 : blocks) {
            class_2680 oldState2 = level.method_8320(pos2);
            level.method_8652(pos2, air, 16);
            level.method_16109(pos2, oldState2, level.method_8320(pos2));
            blockStates.put(pos2, oldState2);
        }
        blockStates.forEach((pos, oldState) -> {
            class_2680 newState = level.method_8320(pos);
            level.method_8413(pos, oldState, newState, 3);
            level.method_8413(pos, oldState, newState, 3);
            level.method_8408(pos, newState.method_26204());
            newState.method_30102((class_1936)level, pos, 511);
            oldState.method_30101((class_1936)level, pos, 511);
            oldState.method_30102((class_1936)level, pos, 511);
            level.method_19282(pos, oldState, newState);
        });
        level.method_8649((class_1297)entity);
        return true;
    }

    public static TreeData tryGatherTreeData(TreeType treeType, class_2338 blockPos, class_1937 level, class_1657 player, boolean ignoreExceptions) {
        block4: {
            try {
                return treeType.gatherTreeData(blockPos, level, player);
            }
            catch (TreeException e) {
                if (!ignoreExceptions) {
                    LOGGER.warn(e.getMessage());
                }
            }
            catch (Exception e) {
                if (ignoreExceptions) break block4;
                LOGGER.error("An error occurred when trying to gather tree data", (Throwable)e);
                player.method_7353((class_2561)class_2561.method_43470((String)("Error: " + String.valueOf(e))).method_27696(class_2583.field_24360.method_36139(Color.red.getRGB())), false);
                player.method_7353((class_2561)class_2561.method_43471((String)"text.fallingtrees.tree_handler.exception.1").method_27696(class_2583.field_24360.method_36139(Color.red.getRGB())), false);
                player.method_7353((class_2561)class_2561.method_43471((String)"text.fallingtrees.tree_handler.exception.2").method_27696(class_2583.field_24360.method_36139(Color.red.getRGB())), false);
            }
        }
        return null;
    }

    public static boolean canPlayerChopTree(class_1657 player) {
        ClientConfig clientConfig = FallingTreesConfig.getClientConfig(player);
        if (clientConfig == null) {
            RunUtil.runOnce((String)("falling_trees_player_client_config_missing_" + String.valueOf(player.method_5667())), () -> LOGGER.warn("Couldn't find client config for player: {} [{}]", (Object)player.method_5476().getString(), (Object)player.method_5667()));
            return false;
        }
        boolean invertCrouchMining = clientConfig.invertCrouchMining;
        return FallingTreesConfig.getCommonConfig().disableCrouchMining || player.method_18276() == invertCrouchMining;
    }

    public static Optional<Float> getMiningSpeed(class_1657 player, class_2338 blockPos, float baseSpeed) {
        TreeSpeed treeSpeed = TREE_SPEED_CACHES.compute(player.method_5667(), (uuid, speed) -> {
            if (speed == null || !speed.isValid(blockPos, baseSpeed)) {
                class_2680 blockState = player.method_37908().method_8320(blockPos);
                TreeType tree = TreeRegistry.getTree(blockState);
                if (tree == null) {
                    return null;
                }
                TreeData data = TreeHandler.tryGatherTreeData(tree, blockPos, player.method_37908(), player, true);
                if (data == null) {
                    return null;
                }
                return new TreeSpeed(baseSpeed, data.miningSpeedModifier().getMiningSpeed(baseSpeed), blockPos.method_10062());
            }
            return speed;
        });
        return Optional.ofNullable(treeSpeed).map(TreeSpeed::getMiningSpeed);
    }

    public static final class TreeSpeed {
        private final float baseMiningSpeed;
        private final float miningSpeed;
        private final class_2338 blockPos;

        public TreeSpeed(float baseMiningSpeed, float miningSpeed, class_2338 blockPos) {
            this.baseMiningSpeed = baseMiningSpeed;
            this.miningSpeed = miningSpeed;
            this.blockPos = blockPos;
        }

        public float getMiningSpeed() {
            return this.miningSpeed;
        }

        public boolean isValid(class_2338 blockPos, float baseSpeed) {
            return Objects.equals(this.blockPos, blockPos) && this.baseMiningSpeed == baseSpeed;
        }
    }
}

