/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.gui.RewardNotificationsScreen;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class LootReward
extends RandomReward {
    public LootReward(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.LOOT;
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        RewardTable table = this.getTable();
        if (table != null) {
            for (WeightedReward wr : table.generateWeightedRandomRewards(player.method_59922(), 1, true)) {
                wr.getReward().claim(player, notify);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, true);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick) {
            new RewardNotificationsScreen().openGui();
        }
        super.onButtonClicked(button, canClick);
    }

    @Override
    public boolean getExcludeFromClaimAll() {
        return true;
    }

    @Override
    public boolean automatedClaimPre(class_2586 blockEntity, List<class_1799> items, class_5819 random, UUID playerId, @Nullable class_3222 player) {
        return false;
    }

    @Override
    public void automatedClaimPost(class_2586 blockEntity, UUID playerId, @Nullable class_3222 player) {
    }
}

