/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.gui.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.client.gui.CustomToast;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestPositionableButton;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class QuestButton
extends Button
implements QuestPositionableButton {
    protected final QuestScreen questScreen;
    final Quest quest;
    private Collection<QuestButton> dependencies = null;

    public QuestButton(Panel panel, Quest quest) {
        super(panel, quest.getTitle(), quest.getIcon());
        this.questScreen = (QuestScreen)panel.getGui();
        this.setSize(20, 20);
        this.quest = quest;
    }

    public boolean isEnabled() {
        return this.questScreen.file.canEdit() || this.quest.isVisible(this.questScreen.file.selfTeamData);
    }

    public boolean shouldDraw() {
        return this.questScreen.file.canEdit() || this.quest.isVisible(this.questScreen.file.selfTeamData);
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (!this.shouldDraw() || this.questScreen.movingObjects || this.questScreen.viewQuestPanel.isMouseOver() || this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        if (this.questScreen.questPanel.mouseOverQuest != null && this.questScreen.questPanel.mouseOverQuest != this) {
            this.isMouseOver = false;
        }
        if (this.isMouseOver) {
            QuestShape shape = QuestShape.get(this.quest.getShape());
            int ax = this.getX();
            int ay = this.getY();
            double relX = (double)(mouseX - ax) / (double)this.width;
            double relY = (double)(mouseY - ay) / (double)this.height;
            PixelBuffer pixelBuffer = shape.getShapePixels();
            int rx = (int)(relX * (double)pixelBuffer.getWidth());
            int ry = (int)(relY * (double)pixelBuffer.getHeight());
            if (rx < 0 || ry < 0 || rx >= pixelBuffer.getWidth() || ry >= pixelBuffer.getHeight()) {
                this.isMouseOver = false;
            } else {
                int a = pixelBuffer.getRGB(rx, ry) >> 24 & 0xFF;
                if (a < 5) {
                    this.isMouseOver = false;
                }
            }
        }
        if (this.isMouseOver && this.questScreen.questPanel.mouseOverQuest == null) {
            this.questScreen.questPanel.mouseOverQuest = this;
        }
    }

    public Collection<QuestButton> getDependencies() {
        if (this.dependencies == null) {
            ArrayList list = new ArrayList();
            this.quest.streamDependencies().forEach(dependency -> {
                if (dependency.isValid() && dependency instanceof Quest) {
                    for (Widget widget : this.questScreen.questPanel.getWidgets()) {
                        if (!(widget instanceof QuestButton)) continue;
                        QuestButton qb = (QuestButton)widget;
                        if (dependency != qb.quest) continue;
                        list.add(qb);
                    }
                }
            });
            this.dependencies = List.copyOf(list);
        }
        return this.dependencies;
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        boolean canEdit = this.questScreen.file.canEdit();
        if (canEdit && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            Collection<Quest> selected = this.questScreen.getSelectedQuests();
            if (!selected.isEmpty()) {
                if (!selected.contains(this.quest)) {
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.add_dependencies"), (Icon)ThemeProperties.ADD_ICON.get(), b -> selected.forEach(q -> this.editDependency(this.quest, (QuestObject)q, true))));
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.remove_dependencies"), (Icon)ThemeProperties.DELETE_ICON.get(), b -> selected.forEach(q -> this.editDependency(this.quest, (QuestObject)q, false))));
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.add_dependencies_self"), (Icon)ThemeProperties.ADD_ICON.get(), b -> selected.forEach(q -> this.editDependency((Quest)q, this.quest, true))));
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.remove_dependencies_self"), (Icon)ThemeProperties.DELETE_ICON.get(), b -> selected.forEach(q -> this.editDependency((Quest)q, this.quest, false))));
                } else {
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.quest), b -> {
                        this.questScreen.movingObjects = true;
                    }));
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.add_reward_all"), (Icon)ThemeProperties.ADD_ICON.get(this.quest), b -> this.openAddRewardContextMenu()));
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.clear_reward_all"), (Icon)ThemeProperties.CLOSE_ICON.get(this.quest), b -> selected.forEach(q -> q.getRewards().forEach(r -> NetworkManager.sendToServer((class_8710)new DeleteObjectMessage(r.id))))));
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.bulk_change_size"), Icons.SETTINGS, b -> this.bulkChangeSize()));
                    contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(this.quest), b -> this.questScreen.deleteSelectedObjects()).setYesNoText((class_2561)class_2561.method_43469((String)"delete_item", (Object[])new Object[]{class_2561.method_43471((String)"ftbquests.quests").method_27693(" [" + this.questScreen.selectedObjects.size() + "]")})));
                }
                contextMenu.add(ContextMenuItem.SEPARATOR);
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43470((String)"Ctrl+A to select all quests").method_27692(class_124.field_1080), Icons.INFO, null).setCloseMenu(false));
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43470((String)"Ctrl+D to deselect all quests").method_27692(class_124.field_1080), Icons.INFO, null).setCloseMenu(false));
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43470((String)"Ctrl+Arrow Key to move selected quests").method_27692(class_124.field_1080), Icons.INFO, null).setCloseMenu(false));
                this.getGui().openContextMenu(contextMenu);
            } else {
                ContextMenuBuilder.create(this.theQuestObject(), this.questScreen).withDeletionFocus(this.moveAndDeleteFocus()).insertAtTop(List.of(new TooltipContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.quest), b -> this.questScreen.initiateMoving(this.moveAndDeleteFocus()), new class_2561[]{class_2561.method_43471((String)"ftbquests.gui.move_tooltip").method_27692(class_124.field_1063)}))).openContextMenu(this.getGui());
            }
        } else if (button.isLeft()) {
            if (QuestButton.isCtrlKeyDown() && canEdit) {
                if (this.questScreen.isViewingQuest()) {
                    this.questScreen.closeQuest();
                }
                this.questScreen.toggleSelected(this.moveAndDeleteFocus());
            } else if (QuestButton.isKeyDown((int)342) && canEdit) {
                this.quest.onEditButtonClicked((Runnable)((Object)this.questScreen));
            } else if (QuestButton.isKeyDown((int)346) && canEdit) {
                this.quest.copyToClipboard();
                class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)class_2561.method_43471((String)"ftbquests.quest.copied"), Icons.INFO, (class_2561)class_2561.method_43470((String)this.moveAndDeleteFocus().getTitle().getString())));
            } else if (!this.quest.getGuidePage().isEmpty() && this.quest.getTasks().isEmpty() && this.quest.getRewards().isEmpty() && this.quest.getDescription().isEmpty()) {
                this.handleClick("guide", this.quest.getGuidePage());
            } else if (canEdit || !this.quest.hideDetailsUntilStartable() || this.questScreen.file.selfTeamData.canStartTasks(this.quest)) {
                this.questScreen.open(this.theQuestObject(), false);
            }
        } else if (canEdit && button.isMiddle()) {
            if (!this.questScreen.selectedObjects.contains(this.moveAndDeleteFocus())) {
                this.questScreen.toggleSelected(this.moveAndDeleteFocus());
            }
            this.questScreen.movingObjects = true;
        } else if (button.isRight()) {
            this.questScreen.movingObjects = false;
            if (this.questScreen.getViewedQuest() != this.quest) {
                this.questScreen.viewQuest(this.quest);
            } else {
                this.questScreen.closeQuest();
            }
        }
    }

    private void bulkChangeSize() {
        Collection<Quest> quests = this.questScreen.getSelectedQuests();
        if (quests.isEmpty()) {
            return;
        }
        DoubleConfig c = new DoubleConfig(0.0625, 8.0);
        c.setValue((Object)quests.stream().findFirst().map(Quest::getSize).orElse(1.0));
        EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)this.getGui(), (ConfigFromString)c, accepted -> {
            if (accepted) {
                quests.forEach(q -> {
                    q.setSize((Double)c.getValue());
                    NetworkManager.sendToServer((class_8710)EditObjectMessage.forQuestObject(q));
                });
            }
            this.run();
        }, (class_2561)class_2561.method_43471((String)"ftbquests.quest.appearance.size")).atMousePosition();
        overlay.setExtraZlevel(600);
        this.getGui().pushModalPanel((ModalPanel)overlay);
    }

    private void openAddRewardContextMenu() {
        ArrayList<ContextMenuItem> contextMenu2 = new ArrayList<ContextMenuItem>();
        for (RewardType type : RewardTypes.TYPES.values()) {
            if (type.getGuiProvider() == null) continue;
            contextMenu2.add(new ContextMenuItem(type.getDisplayName(), type.getIconSupplier(), b -> {
                this.playClickSound();
                type.getGuiProvider().openCreationGui(this.parent, this.quest, reward -> this.questScreen.getSelectedQuests().forEach(quest -> {
                    Reward newReward = QuestObjectBase.copy(reward, () -> type.createReward(0L, (Quest)quest));
                    if (newReward != null) {
                        class_2487 extra = new class_2487();
                        extra.method_10582("type", type.getTypeForNBT());
                        NetworkManager.sendToServer((class_8710)CreateObjectMessage.create(newReward, extra));
                    }
                }));
            }));
        }
        this.getGui().openContextMenu(contextMenu2);
    }

    private void editDependency(Quest quest, QuestObject object, boolean add) {
        List<QuestObject> prevDeps = quest.streamDependencies().toList();
        if (add != quest.hasDependency(object)) {
            if (add) {
                quest.addDependency(object);
            } else {
                quest.removeDependency(object);
            }
        }
        quest.removeInvalidDependencies();
        if (quest.verifyDependencies(false)) {
            NetworkManager.sendToServer((class_8710)EditObjectMessage.forQuestObject(quest));
            this.questScreen.questPanel.refreshWidgets();
        } else {
            quest.clearDependencies();
            prevDeps.forEach(quest::addDependency);
            QuestScreen.displayError((class_2561)class_2561.method_43471((String)"ftbquests.gui.looping_dependencies"));
        }
    }

    public Optional<PositionedIngredient> getIngredientUnderMouse() {
        return this.quest.getTasks().size() == 1 ? this.quest.getTasks().stream().findFirst().orElseThrow().getIngredient((Widget)this) : Optional.empty();
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.quest);
        class_2561 title = this.getTitle();
        TeamData teamData = this.questScreen.file.selfTeamData;
        if (teamData != null && teamData.isStarted(this.quest) && !teamData.isCompleted(this.quest)) {
            title = title.method_27661().method_10852((class_2561)class_2561.method_43470((String)(" " + teamData.getRelativeProgress(this.quest) + "%")).method_27692(class_124.field_1063));
        }
        if (title.getString().contains("\n")) {
            title.method_27658((style, txt) -> {
                for (String s : txt.split("\n")) {
                    if (s.isEmpty()) continue;
                    list.add((class_2561)class_2561.method_43470((String)s).method_27696(style));
                }
                return Optional.empty();
            }, title.method_10866());
        } else {
            list.add(title);
        }
        class_2561 description = this.quest.getSubtitle();
        if (!TextUtils.isComponentEmpty(description)) {
            list.add((class_2561)description.method_27661().method_27692(class_124.field_1080));
        }
        if (this.quest.isOptional()) {
            list.add((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"ftbquests.quest.misc.optional")).method_27693("]"));
        }
        if (this.quest.canBeRepeated()) {
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.quest.misc.can_repeat").method_27692(class_124.field_1080));
        }
        if (teamData != null && !teamData.canStartTasks(this.quest)) {
            String key = teamData.isExcludedByOtherQuestline(this.quest) ? "ftbquests.quest.locked.excluded" : "ftbquests.quest.locked";
            list.add((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43471((String)key)).method_27693("]"));
        }
        if (this.quest.isExclusiveQuest()) {
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.quest.misc.exclusive").method_27692(class_124.field_1065));
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.quest.misc.exclusive.desc").method_54663(-4161536));
        }
    }

    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        int s;
        QuestShape shape;
        Color4I outlineColor = (Color4I)ThemeProperties.QUEST_NOT_STARTED_COLOR.get(this.quest);
        Object questIcon = Color4I.empty();
        Color4I hiddenIcon = Color4I.empty();
        Color4I lockIcon = Color4I.empty();
        TeamData teamData = this.questScreen.file.selfTeamData;
        boolean isCompleted = teamData.isCompleted(this.quest);
        boolean isStarted = isCompleted || teamData.isStarted(this.quest);
        boolean canStart = teamData.areDependenciesComplete(this.quest) && !teamData.isExcludedByOtherQuestline(this.quest);
        class_746 player = class_310.method_1551().field_1724;
        if (canStart) {
            if (isCompleted) {
                questIcon = teamData.hasUnclaimedRewards(player.method_5667(), this.quest) ? (Icon)ThemeProperties.ALERT_ICON.get(this.quest) : (teamData.isQuestPinned((class_1657)player, this.quest.id) ? (Icon)ThemeProperties.PIN_ICON_ON.get() : (Icon)ThemeProperties.CHECK_ICON.get(this.quest));
                outlineColor = (Color4I)ThemeProperties.QUEST_COMPLETED_COLOR.get(this.quest);
            } else if (isStarted) {
                if (teamData.areDependenciesComplete(this.quest)) {
                    outlineColor = (Color4I)ThemeProperties.QUEST_STARTED_COLOR.get(this.quest);
                }
                if (this.quest.getProgressionMode() == ProgressionMode.FLEXIBLE && this.quest.allTasksCompleted(teamData)) {
                    questIcon = new ThemeProperties.CheckIcon(Color4I.rgb((int)0x606060), Color4I.rgb((int)0x808080));
                }
            }
        } else {
            outlineColor = (Color4I)ThemeProperties.QUEST_LOCKED_COLOR.get(this.quest);
        }
        if (questIcon == Color4I.empty() && teamData.isQuestPinned((class_1657)player, this.quest.id)) {
            questIcon = (Icon)ThemeProperties.PIN_ICON_ON.get();
        }
        if (this.questScreen.file.canEdit() && !this.quest.isVisible(teamData)) {
            hiddenIcon = (Icon)ThemeProperties.HIDDEN_ICON.get();
        }
        if ((shape = QuestShape.get(this.getShape())).shouldDraw()) {
            shape.getShape().withColor(Color4I.DARK_GRAY).draw(graphics, x, y, w, h);
            shape.getBackground().withColor(Color4I.WHITE.withAlpha(150)).draw(graphics, x, y, w, h);
            shape.getOutline().withColor(outlineColor).draw(graphics, x, y, w, h);
        }
        class_4587 poseStack = graphics.method_51448();
        if (!this.icon.isEmpty()) {
            s = (int)((float)w * 0.6666667f * (float)this.quest.getIconScale());
            poseStack.method_22903();
            poseStack.method_22904((double)x + (double)(w - s) / 2.0, (double)y + (double)(h - s) / 2.0, 0.0);
            this.icon.draw(graphics, 0, 0, s, s);
            poseStack.method_22909();
        }
        GuiHelper.setupDrawing();
        if (this.questScreen.getViewedQuest() == this.quest || this.questScreen.selectedObjects.contains(this.moveAndDeleteFocus())) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 1.0f);
            Color4I col = Color4I.WHITE.withAlpha((int)(190.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
            shape.getOutline().withColor(col).draw(graphics, x, y, w, h);
            shape.getBackground().withColor(col).draw(graphics, x, y, w, h);
            poseStack.method_22909();
        }
        if (!canStart || !teamData.areDependenciesComplete(this.quest)) {
            if (shape.shouldDraw()) {
                shape.getShape().withColor(Color4I.BLACK.withAlpha(100)).draw(graphics, x, y, w, h);
            }
            if (this.quest.getQuestFile().showLockIcons() && ((Boolean)FTBQuestsClientConfig.SHOW_LOCK_ICON.get()).booleanValue()) {
                lockIcon = (Icon)ThemeProperties.LOCK_ICON.get();
            }
        }
        if (this.isMouseOver()) {
            shape.getShape().withColor(Color4I.WHITE.withAlpha(100)).draw(graphics, x, y, w, h);
        }
        if (!questIcon.isEmpty()) {
            s = (int)((float)w / 8.0f * 3.0f);
            poseStack.method_22903();
            poseStack.method_46416((float)(x + w - s), (float)y, 900.0f);
            questIcon.draw(graphics, 0, 0, s, s);
            poseStack.method_22909();
        }
        if (!hiddenIcon.isEmpty()) {
            s = (int)((float)w / 8.0f * 3.0f);
            poseStack.method_22903();
            poseStack.method_46416((float)x, (float)y, 900.0f);
            hiddenIcon.draw(graphics, 0, 0, s, s);
            poseStack.method_22909();
        }
        if (!lockIcon.isEmpty() && !this.quest.shouldHideLockIcon()) {
            s = (int)((float)w / 8.0f * 3.0f);
            poseStack.method_22903();
            poseStack.method_46416((float)(x + w - s), (float)(y + h - 1 - s), 900.0f);
            lockIcon.draw(graphics, 0, 0, s, s);
            poseStack.method_22909();
        }
    }

    protected String getShape() {
        return this.quest.getShape();
    }

    @Override
    public QuestPositionableButton.Position getPosition() {
        return new QuestPositionableButton.Position(this.quest.getX(), this.quest.getY(), this.quest.getWidth(), this.quest.getHeight());
    }

    protected QuestObject theQuestObject() {
        return this.quest;
    }

    @Override
    public Movable moveAndDeleteFocus() {
        return (Movable)((Object)this.theQuestObject());
    }
}

