/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;
import dev.ftb.mods.ftbquests.client.AutoPinTarget;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public enum PinnedQuestsTracker {
    INSTANCE;

    private static final int INTERVAL = 30;
    public static final int VERTICAL_SPACING = 3;
    private final List<class_5481> pinnedQuestText = new ArrayList<class_5481>();
    private int ticker = 0;
    private boolean showChapterTitle;

    public void tick(ClientQuestFile file) {
        if (++this.ticker >= 30) {
            this.collectPinnedQuests(file);
            this.ticker = 0;
        }
    }

    public void refresh() {
        this.ticker = 30;
    }

    private void collectPinnedQuests(ClientQuestFile file) {
        TeamData data = file.selfTeamData;
        this.showChapterTitle = false;
        ArrayList<Quest> pinnedQuests = new ArrayList<Quest>();
        LongSet pinnedIds = data.getPinnedQuestIds(FTBQuestsClient.getClientPlayer());
        if (!pinnedIds.isEmpty()) {
            if (pinnedIds.contains(1L)) {
                boolean wholeBook = FTBQuestsClientConfig.AUTO_PIN_FOLLOWS.get() == AutoPinTarget.QUEST_BOOK;
                file.forAllQuests(quest -> {
                    if (!data.isCompleted((QuestObject)quest) && quest.isVisible(data) && data.canStartTasks((Quest)quest) && (wholeBook || file.isChapterSelected(quest.getChapter()))) {
                        pinnedQuests.add((Quest)quest);
                    }
                });
                this.showChapterTitle = !wholeBook;
            } else {
                pinnedIds.longStream().mapToObj(file::getQuest).filter(Objects::nonNull).forEach(pinnedQuests::add);
            }
        }
        this.rebuildPinnedText(pinnedQuests, class_310.method_1551(), data);
    }

    private void rebuildPinnedText(List<Quest> pinnedQuests, class_310 mc, TeamData data) {
        this.pinnedQuestText.clear();
        for (int i = 0; i < pinnedQuests.size(); ++i) {
            Quest quest = pinnedQuests.get(i);
            if (i > 0) {
                this.pinnedQuestText.add(class_5481.field_26385);
            }
            this.pinnedQuestText.addAll(mc.field_1772.method_1728(class_5348.method_29433((class_5348[])new class_5348[]{mc.field_1772.method_27527().method_27490((class_5348)quest.getTitle(), 160, class_2583.field_24360.method_10982(Boolean.valueOf(true))), class_2561.method_43470((String)" ").method_27692(class_124.field_1062).method_27693(data.getRelativeProgress(quest) + "%")}), 500));
            for (Task task : quest.getTasks()) {
                if (data.isCompleted(task)) continue;
                this.pinnedQuestText.addAll(mc.field_1772.method_1728(class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"\u2514").method_27692(class_124.field_1080), mc.field_1772.method_27527().method_27490((class_5348)task.getMutableTitle().method_27692(class_124.field_1080), 160, class_2583.field_24360.method_27706(class_124.field_1080)), class_2561.method_43470((String)" ").method_27692(class_124.field_1060).method_27693(task.formatProgress(data, data.getProgress(task))).method_27693("/").method_27693(task.formatMaxProgress())}), 500));
            }
        }
    }

    void render(class_310 mc, class_332 graphics) {
        if (this.pinnedQuestText.isEmpty()) {
            return;
        }
        class_5250 title = class_2561.method_43471((String)"ftbquests.pinned");
        if (this.showChapterTitle) {
            ClientQuestFile.INSTANCE.getQuestScreen().flatMap(QuestScreen::getSelectedChapter).ifPresent(chapter -> title.method_27693(": ").method_10852(chapter.getTitle()));
        }
        int titleWidth = mc.field_1772.method_27525((class_5348)title);
        int width = titleWidth + 5;
        Objects.requireNonNull(mc.field_1772);
        int height = 9 + 10;
        for (class_5481 s : this.pinnedQuestText) {
            int n;
            width = Math.max(width, (int)mc.field_1772.method_27527().method_30875(s));
            if (s == class_5481.field_26385) {
                n = 3;
            } else {
                Objects.requireNonNull(mc.field_1772);
                n = 9;
            }
            height += n;
        }
        float scale = ((Double)FTBQuestsClientConfig.PINNED_QUESTS_SCALE.get()).floatValue();
        int insetX = (Integer)FTBQuestsClientConfig.PINNED_QUESTS_INSET_X.get();
        int insetY = (Integer)FTBQuestsClientConfig.PINNED_QUESTS_INSET_Y.get();
        PanelPositioning.PanelPos pos = ((PanelPositioning)FTBQuestsClientConfig.PINNED_QUESTS_POS.get()).getPanelPos(mc.method_22683().method_4486(), mc.method_22683().method_4502(), (int)((float)(width += 8) * scale), (int)((float)height * scale), insetX, insetY);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)pos.x(), (float)pos.y(), 100.0f);
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        GuiHelper.drawHollowRect((class_332)graphics, (int)0, (int)0, (int)width, (int)height, (Color4I)Color4I.BLACK.withAlpha(100), (boolean)false);
        Color4I.BLACK.withAlpha(100).draw(graphics, 0, 0, width, height);
        Color4I color4I = Color4I.GRAY.withAlpha(50);
        Objects.requireNonNull(mc.field_1772);
        color4I.draw(graphics, 1, 1, width - 2, 9 + 4);
        Objects.requireNonNull(mc.field_1772);
        Color4I.BLACK.draw(graphics, 0, 9 + 4, width, 1);
        graphics.method_27535(mc.field_1772, (class_2561)title, (width - titleWidth) / 2, 4, -256);
        Objects.requireNonNull(mc.field_1772);
        int yPos = 9 + 8;
        for (class_5481 fcs : this.pinnedQuestText) {
            if (fcs == class_5481.field_26385) {
                yPos += 3;
                continue;
            }
            graphics.method_35720(mc.field_1772, fcs, 4, yPos, -1);
            Objects.requireNonNull(mc.field_1772);
            yPos += 9;
        }
        graphics.method_51448().method_22909();
    }
}

