/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public enum NotificationStyle {
    TOAST("toast", NotificationStyle::completionToast, NotificationStyle::rewardToast),
    CHAT("chat", NotificationStyle::completionChat, NotificationStyle::rewardChat),
    ACTION_BAR("action_bar", NotificationStyle::completionActionBar, NotificationStyle::rewardActionBar),
    NONE("none", NotificationStyle::completionNone, NotificationStyle::rewardNone);

    public static final NotificationStyle[] VALUES;
    public static final NameMap<NotificationStyle> NAME_MAP;
    private final String id;
    private final Consumer<QuestObject> onComplete;
    private final BiConsumer<class_2561, Icon> onReward;

    private NotificationStyle(String id, Consumer<QuestObject> onComplete, BiConsumer<class_2561, Icon> onReward) {
        this.id = id;
        this.onComplete = onComplete;
        this.onReward = onReward;
    }

    public boolean notifyCompletion(long id) {
        QuestObject object = ClientQuestFile.INSTANCE.get(id);
        if (object != null) {
            this.onComplete.accept(object);
            return true;
        }
        return false;
    }

    public void notifyReward(class_2561 text, Icon icon) {
        this.onReward.accept(text, icon);
    }

    private static void completionToast(QuestObject qo) {
        FTBQuestsClient.showCompletionToast(qo);
    }

    private static void rewardToast(class_2561 text, Icon icon) {
        FTBQuestsClient.showRewardToast(text, icon);
    }

    private static void completionChat(QuestObject qo) {
        NotificationStyle.chatMsg(qo, false);
    }

    private static void rewardChat(class_2561 component, Icon icon) {
        FTBQuestsClient.getClientPlayer().method_7353(NotificationStyle.formatRewardMsg(component), false);
    }

    private static void completionActionBar(QuestObject qo) {
        NotificationStyle.chatMsg(qo, true);
    }

    private static void rewardActionBar(class_2561 component, Icon icon) {
        FTBQuestsClient.getClientPlayer().method_7353(NotificationStyle.formatRewardMsg(component), true);
    }

    private static void completionNone(QuestObject qo) {
    }

    private static void rewardNone(class_2561 text, Icon icon) {
    }

    private static class_2561 formatRewardMsg(class_2561 msg) {
        return class_2561.method_43471((String)"ftbquests.reward.collected").method_27692(QuestObjectType.REWARD.getColor()).method_27693(" ").method_10852((class_2561)msg.method_27661().method_27692(class_124.field_1068));
    }

    private static void chatMsg(QuestObject qo, boolean actionBar) {
        class_1657 player = FTBQuestsClient.getClientPlayer();
        if (player != null) {
            class_5250 msg = qo.getObjectType().getCompletedMessage().method_27661().method_27692(qo.getObjectType().getColor());
            player.method_7353((class_2561)msg.method_27693(" ").method_10852((class_2561)qo.getTitle().method_27661().method_27692(class_124.field_1068)), actionBar);
            if (((Boolean)FTBQuestsClientConfig.COMPLETION_SOUNDS.get()).booleanValue()) {
                if (qo instanceof Chapter || qo instanceof BaseQuestFile) {
                    player.method_43077(class_3417.field_15195);
                } else {
                    player.method_43077(class_3417.field_14641);
                }
            }
        }
    }

    static {
        VALUES = NotificationStyle.values();
        NAME_MAP = NameMap.of((Object)((Object)TOAST), (Object[])VALUES).id(v -> v.id).name(n -> class_2561.method_43471((String)("ftbquests.ui.notification." + n.id))).create();
    }
}

