/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.entity.BaseBarrierBlockEntity;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class QuestBarrierBlockEntity
extends BaseBarrierBlockEntity {
    private Quest cachedQuest = null;

    public QuestBarrierBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntityTypes.BARRIER.get(), blockPos, blockState);
    }

    @Override
    protected void applySavedData(BaseBarrierBlockEntity.BarrierSavedData data) {
        super.applySavedData(data);
        this.cachedQuest = null;
    }

    @Override
    public void updateFromString(String objStr) {
        super.updateFromString(objStr);
        this.cachedQuest = null;
        this.method_5431();
    }

    @Override
    public boolean isOpen(class_1657 player) {
        Quest quest = this.getQuest();
        return quest != null && quest.getQuestFile().getTeamData(player).map(d -> d.isCompleted(quest)).orElse(false) != false;
    }

    @Override
    protected void addConfigEntries(ConfigGroup cg) {
        ((ConfigQuestObject)cg.add("quest", new ConfigQuestObject(QuestObjectType.QUEST), (Object)this.getQuest(), this::setQuest, null)).setNameKey("ftbquests.quest");
    }

    public Quest getQuest() {
        if (this.cachedQuest == null && !this.objStr.isEmpty() || this.cachedQuest != null && !this.cachedQuest.getCodeString().equals(this.objStr)) {
            long objId = BaseQuestFile.parseCodeString(this.objStr);
            this.cachedQuest = FTBQuestsAPI.api().getQuestFile(this.field_11863.field_9236).getQuest(objId);
        }
        return this.cachedQuest;
    }

    public void setQuest(Quest quest) {
        this.cachedQuest = quest;
        this.objStr = quest == null ? "" : quest.getCodeString();
        this.method_5431();
    }
}

