/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block;

import com.mojang.serialization.MapCodec;
import dev.architectury.hooks.level.entity.EntityHooks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.block.entity.BaseBarrierBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.QuestBarrierBlockEntity;
import dev.ftb.mods.ftbquests.block.fabric.QuestBarrierBlockImpl;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.net.BlockConfigRequestMessage;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_8710;
import net.minecraft.class_9062;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class QuestBarrierBlock
extends class_2237 {
    private static final MapCodec<QuestBarrierBlock> CODEC = QuestBarrierBlock.method_54094(QuestBarrierBlock::new);
    public static final class_2746 OPEN = class_2746.method_11825((String)"open");
    public static final class_4970.class_2251 PROPS = class_4970.class_2251.method_9637().method_31710(class_3620.field_16024).method_50012(class_3619.field_15972).method_22488().method_26245((blockState, blockGetter, blockPos) -> false).method_26243((blockState, blockGetter, blockPos) -> false).method_9629(-1.0f, 6000000.0f).method_9631(blockState -> 3).method_26249((blockState, blockGetter, blockPos) -> true);

    public QuestBarrierBlock(class_4970.class_2251 props) {
        super(props);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{OPEN});
    }

    protected MapCodec<? extends QuestBarrierBlock> method_53969() {
        return CODEC;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_9549(class_2680 state, class_1922 bg, class_2338 pos, class_3726 ctx) {
        class_1297 class_12972 = EntityHooks.fromCollision((class_3726)ctx);
        if (class_12972 instanceof class_1657) {
            BaseBarrierBlockEntity barrier;
            class_1657 player = (class_1657)class_12972;
            class_12972 = bg.method_8321(pos);
            if (class_12972 instanceof BaseBarrierBlockEntity && (barrier = (BaseBarrierBlockEntity)class_12972).isOpen(player)) {
                return class_259.method_1073();
            }
        }
        return super.method_9549(state, bg, pos, ctx);
    }

    protected class_265 method_9530(class_2680 blockState, class_1922 bg, class_2338 pos, class_3726 ctx) {
        class_1297 class_12972 = EntityHooks.fromCollision((class_3726)ctx);
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (((Boolean)blockState.method_11654((class_2769)OPEN)).booleanValue() && !NetUtils.canEdit(player)) {
                return class_259.method_1073();
            }
        }
        return super.method_9530(blockState, bg, pos, ctx);
    }

    public class_265 method_26159(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 ctx) {
        return class_259.method_1073();
    }

    @Environment(value=EnvType.CLIENT)
    public float method_9575(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return 1.0f;
    }

    public boolean method_9579(class_2680 state, class_1922 bg, class_2338 pos) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_9522(class_2680 state, class_2680 state2, class_2350 dir) {
        return state2.method_27852((class_2248)this) || super.method_9522(state, state2, dir);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        class_2586 class_25862;
        super.method_9567(level, pos, state, entity, stack);
        if (!level.method_8608() && stack.method_57826(class_9334.field_49631) && !stack.method_57826((class_9331)ModDataComponents.BARRIER_SAVED.get()) && (class_25862 = level.method_8321(pos)) instanceof BaseBarrierBlockEntity) {
            BaseBarrierBlockEntity barrier = (BaseBarrierBlockEntity)class_25862;
            barrier.updateFromString(stack.method_7964().getString());
        }
    }

    protected class_9062 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (player instanceof class_3222) {
            BaseBarrierBlockEntity barrier;
            class_3222 sp = (class_3222)player;
            class_2586 class_25862 = level.method_8321(blockPos);
            if (class_25862 instanceof BaseBarrierBlockEntity && (barrier = (BaseBarrierBlockEntity)class_25862).hasPermissionToEdit((class_1657)sp)) {
                NetworkManager.sendToPlayer((class_3222)sp, (class_8710)new BlockConfigRequestMessage(blockPos, BlockConfigRequestMessage.BlockType.BARRIER));
                return class_9062.method_55644((boolean)level.field_9236);
            }
            return class_9062.field_47733;
        }
        return class_9062.field_47728;
    }

    public class_1799 method_9574(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        class_1799 stack = super.method_9574(levelReader, blockPos, blockState);
        class_2586 class_25862 = levelReader.method_8321(blockPos);
        if (class_25862 instanceof BaseBarrierBlockEntity) {
            BaseBarrierBlockEntity barrier = (BaseBarrierBlockEntity)class_25862;
            stack.method_57379((class_9331)ModDataComponents.BARRIER_SAVED.get(), (Object)BaseBarrierBlockEntity.BarrierSavedData.fromBlockEntity(barrier));
            if (!barrier.getSkin().method_7960() && !ClientQuestFile.canClientPlayerEdit()) {
                stack.method_57379(class_9334.field_50239, (Object)barrier.getSkin().method_7964());
            }
        }
        return stack;
    }

    protected void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        class_2586 class_25862;
        class_3222 player;
        if (entity instanceof class_3222 && (player = (class_3222)entity).method_5682() != null && (class_25862 = level.method_8321(blockPos)) instanceof BaseBarrierBlockEntity) {
            BaseBarrierBlockEntity b = (BaseBarrierBlockEntity)class_25862;
            b.optionalTeleportData().ifPresent(teleportData -> {
                if (teleportData.enabled() && b.isOpen((class_1657)player)) {
                    TeleportTicker.addPending(player, teleportData.effectiveDest(b.method_11016()));
                }
            });
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return level != null && level.field_9236 ? BaseBarrierBlockEntity::tick : null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return QuestBarrierBlock.questBlockEntityProvider().create(blockPos, blockState);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2591.class_5559<QuestBarrierBlockEntity> questBlockEntityProvider() {
        return QuestBarrierBlockImpl.questBlockEntityProvider();
    }

    public static class TeleportTicker {
        private static final Map<UUID, BaseBarrierBlockEntity.TeleportData> pendingTeleports = new HashMap<UUID, BaseBarrierBlockEntity.TeleportData>();

        public static void tick(MinecraftServer server) {
            if (!pendingTeleports.isEmpty()) {
                pendingTeleports.forEach((id, teleportData) -> teleportData.teleportPlayer(server.method_3760().method_14602(id)));
                pendingTeleports.clear();
            }
        }

        public static void addPending(class_3222 player, BaseBarrierBlockEntity.TeleportData teleportData) {
            pendingTeleports.put(player.method_5667(), teleportData);
        }
    }
}

