/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reputation.provider;

import atonkish.reputation.entity.passive.VillagerEntityInterface;
import atonkish.reputation.util.cache.VillagerCache;
import com.google.common.cache.Cache;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import snownee.jade.Jade;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;

public enum VillagerSnitchProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    public static final class_2960 VILLAGER_SNITCH_IDENTIFIER;
    public static final String IS_SNITCH_KEY = "ReputationModIsSnitch";

    public class_2960 getUid() {
        return VILLAGER_SNITCH_IDENTIFIER;
    }

    public int getDefaultPriority() {
        return -10001;
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        class_2487 data = accessor.getServerData();
        class_1657 player = accessor.getPlayer();
        class_1646 villager = (class_1646)accessor.getEntity();
        VillagerCache.Data villagerData = VillagerSnitchProvider.getVillagerData(data, player, villager);
        IWailaConfig wailaConfig = (IWailaConfig)Jade.CONFIG.get();
        String name = Optional.ofNullable(villager.method_5797()).orElse(villager.method_5864().method_5897()).getString();
        class_2561 text = wailaConfig.getFormatting().registryName(name);
        if (villagerData.isSnitch()) {
            String snitchTranslateKey = String.format("entity.%s.villager.snitch", "reputation");
            class_5250 mText = class_2561.method_43473();
            mText = mText.method_10852((class_2561)text.method_27661().method_27692(class_124.field_1055));
            mText = mText.method_27693(" ");
            mText = mText.method_10852((class_2561)class_2561.method_43471((String)snitchTranslateKey).method_27692(class_124.field_1079));
            text = mText;
        }
        tooltip.add(text);
    }

    public final void appendServerData(class_2487 data, EntityAccessor accessor) {
        class_1657 player = accessor.getPlayer();
        class_1646 villager = (class_1646)accessor.getEntity();
        boolean isSnitch = ((VillagerEntityInterface)villager).isSnitch(player);
        data.method_10556(IS_SNITCH_KEY, isSnitch);
    }

    private static VillagerCache.Data getVillagerData(class_2487 data, class_1657 player, class_1646 villager) {
        Boolean isSnitch;
        Cache<class_1646, VillagerCache.Data> villagerCache = VillagerCache.getOrCreate(player);
        VillagerCache.Data villagerData = Optional.ofNullable((VillagerCache.Data)villagerCache.getIfPresent((Object)villager)).orElse(new VillagerCache.Data());
        Boolean bl = isSnitch = data.method_10545(IS_SNITCH_KEY) ? Boolean.valueOf(data.method_10577(IS_SNITCH_KEY)) : null;
        if (isSnitch != null) {
            villagerData.setIsSnitch(isSnitch);
        }
        villagerCache.put((Object)villager, (Object)villagerData);
        return villagerData;
    }

    static {
        VILLAGER_SNITCH_IDENTIFIER = class_2960.method_60655((String)"reputation", (String)"villager_snitch");
    }
}

