/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reputation.provider;

import atonkish.reputation.util.ReputationStatus;
import atonkish.reputation.util.cache.VillagerCache;
import com.google.common.cache.Cache;
import java.util.Optional;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum VillagerReputationProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    public static final class_2960 VILLAGER_REPUTATION_IDENTIFIER;
    public static final String REPUTATION_KEY = "ReputationModReputation";

    public class_2960 getUid() {
        return VILLAGER_REPUTATION_IDENTIFIER;
    }

    public int getDefaultPriority() {
        return 100;
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        class_2487 data = accessor.getServerData();
        class_1657 player = accessor.getPlayer();
        class_1646 villager = (class_1646)accessor.getEntity();
        VillagerCache.Data villagerData = VillagerReputationProvider.getVillagerData(data, player, villager);
        @Nullable Integer reputation = villagerData.getReputation();
        ReputationStatus status = ReputationStatus.getStatus(reputation);
        class_5250 text = class_2561.method_43471((String)status.getTranslateKey());
        if (reputation != null) {
            text = text.method_27693(String.format(" (%d)", reputation));
        }
        text = text.method_27692(status.getFormatting());
        tooltip.add((class_2561)text);
    }

    public final void appendServerData(class_2487 data, EntityAccessor accessor) {
        class_1657 player = accessor.getPlayer();
        class_1646 villager = (class_1646)accessor.getEntity();
        int reputation = villager.method_20594(player);
        data.method_10569(REPUTATION_KEY, reputation);
    }

    private static VillagerCache.Data getVillagerData(class_2487 data, class_1657 player, class_1646 villager) {
        Integer reputation;
        Cache<class_1646, VillagerCache.Data> villagerCache = VillagerCache.getOrCreate(player);
        VillagerCache.Data villagerData = Optional.ofNullable((VillagerCache.Data)villagerCache.getIfPresent((Object)villager)).orElse(new VillagerCache.Data());
        Integer n = reputation = data.method_10545(REPUTATION_KEY) ? Integer.valueOf(data.method_10550(REPUTATION_KEY)) : null;
        if (reputation != null) {
            villagerData.setReputation(reputation);
        }
        villagerCache.put((Object)villager, (Object)villagerData);
        return villagerData;
    }

    static {
        VILLAGER_REPUTATION_IDENTIFIER = class_2960.method_60655((String)"reputation", (String)"villager_reputation");
    }
}

