/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.play;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.BackpackProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.network.MessageContext;
import java.util.HashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3989;
import net.minecraft.class_9331;

public class ServerPlayHandler {
    public static void handleCustomiseBackpack(MessageBackpackCosmetics message, MessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        class_1799 stack = Services.BACKPACK.getBackpackStack(player);
        if (!stack.method_7960()) {
            BackpackProperties properties = message.properties();
            Backpack backpack = BackpackManager.instance().getBackpack(properties.model());
            if (backpack == null) {
                return;
            }
            if (!backpack.isUnlocked(player) && !((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue()) {
                return;
            }
            stack.method_57379((class_9331)ModDataComponents.BACKPACK_PROPERTIES.get(), (Object)properties);
        }
    }

    public static void handleOpenBackpack(MessageOpenBackpack message, MessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            BackpackItem.openBackpack(serverPlayer, serverPlayer);
        }
    }

    public static void handleEntityBackpack(MessageEntityBackpack message, MessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        class_1297 entity = player.method_37908().method_8469(message.entityId());
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 otherEntity = (class_1309)entity;
        if (otherEntity instanceof class_3222 && !((Boolean)Config.SERVER.pickpocketing.enabled.get()).booleanValue()) {
            return;
        }
        if (!PickpocketUtil.canSeeBackpack(otherEntity, player)) {
            return;
        }
        if (otherEntity instanceof class_3222) {
            class_3222 otherPlayer = (class_3222)otherEntity;
            if (BackpackItem.openBackpack(otherPlayer, (class_3222)player)) {
                otherPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.backpacked.player_opened"), true);
                player.method_37908().method_43128(player, otherPlayer.method_23317(), otherPlayer.method_23318() + 1.0, otherPlayer.method_23321(), (class_3414)class_3417.field_14581.comp_349(), class_3419.field_15248, 0.75f, 1.0f);
            }
        } else if (otherEntity instanceof class_3989) {
            class_3989 trader = (class_3989)otherEntity;
            WanderingTraderEvents.openBackpack(trader, (class_3222)player);
        }
    }

    public static void handleRequestCustomisation(MessageRequestCustomisation message, MessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        if (((Boolean)Config.SERVER.backpack.disableCustomisation.get()).booleanValue()) {
            return;
        }
        if (Services.BACKPACK.getBackpackStack(player).method_7960()) {
            return;
        }
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> {
            HashMap<class_2960, class_2561> map = new HashMap<class_2960, class_2561>();
            for (Backpack backpack : BackpackManager.instance().getBackpacks()) {
                if (unlockTracker.isUnlocked(backpack.getId())) continue;
                unlockTracker.getProgressTracker(backpack.getId()).ifPresent(progressTracker -> map.put(backpack.getId(), progressTracker.getDisplayComponent()));
            }
            Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageOpenCustomisation(map));
        });
    }
}

