/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.unlock;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.framework.api.sync.DataSerializer;
import com.mrcrayfish.framework.api.sync.SyncedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class UnlockTracker
extends SyncedObject {
    public static final class_9139<class_9129, UnlockTracker> STREAM_CODEC = class_9139.method_56437(UnlockTracker::write, UnlockTracker::read);
    public static final DataSerializer<UnlockTracker> SERIALIZER = new DataSerializer(STREAM_CODEC, UnlockTracker::write, UnlockTracker::read);
    private final Set<class_2960> unlockedBackpacks = new HashSet<class_2960>();
    private final Map<class_2960, IProgressTracker> backpackToProgressTracker;
    private final Map<Class<?>, List<IProgressTracker>> classToProgressTrackers;

    public UnlockTracker() {
        HashMap backpackMap = new HashMap();
        HashMap classMap = new HashMap();
        BackpackManager.instance().getBackpacks().forEach(backpack -> {
            IProgressTracker tracker = backpack.createProgressTracker(backpack.getId());
            if (tracker != null) {
                classMap.computeIfAbsent(tracker.getClass(), c -> new ArrayList()).add(tracker);
                backpackMap.put(backpack.getId(), tracker);
            }
        });
        this.backpackToProgressTracker = ImmutableMap.copyOf(backpackMap);
        this.classToProgressTrackers = ImmutableMap.copyOf(classMap);
    }

    public Set<class_2960> getUnlockedBackpacks() {
        return Collections.unmodifiableSet(this.unlockedBackpacks);
    }

    public Map<class_2960, IProgressTracker> getProgressTrackerMap() {
        return this.backpackToProgressTracker;
    }

    public boolean isUnlocked(class_2960 id) {
        return this.unlockedBackpacks.contains(id);
    }

    public Optional<IProgressTracker> getProgressTracker(class_2960 backpackId) {
        if (!((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue() && !this.unlockedBackpacks.contains(backpackId)) {
            return Optional.ofNullable(this.backpackToProgressTracker.get(backpackId));
        }
        return Optional.empty();
    }

    public <T> List<T> getProgressTrackers(Class<T> trackerClass) {
        if (this.classToProgressTrackers.containsKey(trackerClass)) {
            return this.classToProgressTrackers.get(trackerClass);
        }
        return Collections.emptyList();
    }

    public boolean unlockBackpack(class_2960 id) {
        if (BackpackManager.instance().getBackpack(id) != null) {
            this.markDirty();
            return this.unlockedBackpacks.add(id);
        }
        return false;
    }

    private class_2487 write(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        class_2499 unlockedBackpacks = new class_2499();
        this.unlockedBackpacks.forEach(location -> unlockedBackpacks.add((Object)class_2519.method_23256((String)location.toString())));
        tag.method_10566("UnlockedBackpacks", (class_2520)unlockedBackpacks);
        class_2499 progressTrackers = new class_2499();
        this.backpackToProgressTracker.forEach((location, progressTracker) -> {
            class_2487 progressTag = new class_2487();
            progressTag.method_10582("Id", location.toString());
            class_2487 dataTag = new class_2487();
            progressTracker.write(dataTag);
            progressTag.method_10566("Data", (class_2520)dataTag);
            progressTrackers.add((Object)progressTag);
        });
        tag.method_10566("ProgressTrackers", (class_2520)progressTrackers);
        return tag;
    }

    private static UnlockTracker read(class_2520 tag, class_7225.class_7874 provider) {
        class_2487 data = (class_2487)tag;
        UnlockTracker tracker = new UnlockTracker();
        class_2499 unlockedBackpacks = data.method_10554("UnlockedBackpacks", 8);
        unlockedBackpacks.forEach(t -> tracker.unlockedBackpacks.add(class_2960.method_12829((String)t.method_10714())));
        class_2499 progressTrackers = data.method_10554("ProgressTrackers", 10);
        progressTrackers.forEach(t -> {
            class_2487 progressTag = (class_2487)t;
            class_2960 id = class_2960.method_12829((String)progressTag.method_10558("Id"));
            IProgressTracker progressTracker = tracker.backpackToProgressTracker.get(id);
            if (progressTracker != null) {
                class_2487 dataTag = progressTag.method_10562("Data");
                progressTracker.read(dataTag);
            }
        });
        return tracker;
    }

    private static void write(class_9129 buf, UnlockTracker tracker) {
        buf.method_34062(tracker.unlockedBackpacks, class_2540::method_10812);
        buf.method_10804(tracker.backpackToProgressTracker.size());
        tracker.backpackToProgressTracker.forEach((id, progressTracker) -> {
            buf.method_10812(id);
            class_2487 tag = new class_2487();
            progressTracker.write(tag);
            buf.method_10794((class_2520)tag);
        });
    }

    private static UnlockTracker read(class_9129 buf) {
        UnlockTracker tracker = new UnlockTracker();
        tracker.unlockedBackpacks.addAll(buf.method_34068(HashSet::new, class_2540::method_10810));
        IntStream.range(0, buf.method_10816()).forEach(value -> {
            class_2960 id = buf.method_10810();
            class_2487 tag = buf.method_10798();
            IProgressTracker progressTracker = tracker.backpackToProgressTracker.get(id);
            if (progressTracker != null) {
                progressTracker.read(tag);
            }
        });
        return tracker;
    }
}

